/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_REPEAT_FINDER_H_
#define _GB2_REPEAT_FINDER_H_

#include <core_api/DNAAlphabet.h>

#include <QtCore/QtGlobal>
#include <QtCore/QMutex> 

namespace GB2 {

struct RepeatResult {
	int x;
	int y;
	int l;
};


class DotPlotCalcResultsListener { //todo: QObject + signals
public:
        virtual void percentDone(int p){ Q_UNUSED(p); }
        virtual void calculationFinished(){}
        virtual ~DotPlotCalcResultsListener() {}
};


//// base class ////
class RepeatFinder {
public:
    enum SequenceType {SEQ_TYPE_NUCL, SEQ_TYPE_AMINO, SEQ_TYPE_BYTES};
protected:
	DotPlotCalcResultsListener* resultsListener;
	const char* seqX;
	const char* seqY;
	const quint32 SIZE_X;
	const quint32 SIZE_Y;
	DNAAlphabet* al;
	//const SequenceType SEQ_TYPE;
	const quint32 WINDOW_SIZE;
	const quint32 K;
	const quint32 C;
    
	const quint32 HALF_WINDOW_SIZE_L;
	const quint32 HALF_WINDOW_SIZE_H;

	bool reflective;
	char unknownChar;

	RepeatFinder(const char* seqX, quint32 sizeX, 
                const char* seqY, quint32 sizeY, DNAAlphabet* al, 
                quint32 w, quint32 k);
public:
	virtual ~RepeatFinder(){}

	QMutex resultsMutex;

	//WARN: results offsets started from offset 1 up to SIZE -> todo: realign to 0!
    virtual RepeatResult* getResult(quint32 num) = 0;
	virtual quint32 getNumResults() = 0;


	void setListener(DotPlotCalcResultsListener* l) { resultsListener = l;}

	virtual void startCalculation() = 0;
	virtual void terminateCalculation() = 0;
    virtual bool isRunning() const = 0;

	static RepeatFinder* newInstance(const char *seqx, quint32 sizeX, 
                                    const char *seqY, quint32 sizeY, DNAAlphabet* al,
                                    quint32 w, quint32 mismatches = 0, quint32 nThreads=1); 
};

}//namespace
#endif
