/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DNA_EXPORT_TASK_H_
#define _GB2_DNA_EXPORT_TASK_H_

#include <core_api/Task.h>
#include <datatype/MAlignment.h>

namespace GB2 {

class DNAAlphabet;
class DNATranslation;

class DNAExportTaskSettings {
public:
    DNAExportTaskSettings() {
        merge = false;
        mergeGap = 0;
        strand = TriState_Yes;
        allAminoStrands = false;

    }

    QStringList             names;      // name of every sequence
    QList<QByteArray>       sequences;  // the sequences to copy
    QList<DNAAlphabet*>     alphabets;  // alphabets for the sequences
    QList<DNATranslation*>  complTranslations; // complement translations for a sequence. Used only if 'strand' is 'compl' or 'both'
    QList<DNATranslation*>  aminoTranslations; // amino translation for a sequence. If not NULL -> sequence is translated
    
    QString     fileName; // file to export
    bool        merge;    // if true -> multiple sequences are merged
    int         mergeGap; // the gap between sequences if merged

    TriState    strand; //Yes -> direct, No -> complement, Unknown -> Both
    bool        allAminoStrands; // for every sequence and (every complement if needed) generates 3-frame amino translations
};

class DNAExportSequenceTask : public Task {
    Q_OBJECT
public:
    DNAExportSequenceTask(const DNAExportTaskSettings& s);
   
    void run();

private:
    DNAExportTaskSettings config;
};

class DNAExportAlignmentTask : public Task {
    Q_OBJECT
public:
    DNAExportAlignmentTask(const MAlignment& ma, const QString& fileName);

    void run();

private:
    MAlignment  ma;
    QString     fileName;
};


}//namespace

#endif
