/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_BIOSTRUCT3D_WORMS_RENDERER_H_
#define _GB2_BIOSTRUCT3D_WORMS_RENDERER_H_

#include <QtCore/QSharedDataPointer>
#include <QtCore/QVector>
#include <QtCore/QMap>
#include <QtCore/QPair>

#include <core_api/Vector3D.h>
#include "BioStruct3DGLRender.h"
#include "GraphicUtils.h"

class Object3D;
class AtomData;

namespace GB2 { 

    class WormsGLRenderer : public BioStruct3DGLRenderer {

        struct Monomer {
            Monomer() : alphaCarbon(NULL), carbonylOxygen(NULL) {}
            QSharedDataPointer<AtomData> alphaCarbon;
            QSharedDataPointer<AtomData> carbonylOxygen;
        };

        struct BioPolymer {
            QMap<int,Monomer> monomerMap;
        };
        
        QMap<int, BioPolymer> bioPolymerMap;
        
        struct CoordData {
            CoordData() { }
            CoordData(const Vector3D& v, const Color4f& c, int id) : site(v), color(c), redisueId(id) { } 
            Vector3D site;
            Color4f color;
            int redisueId;
        };
        
        // Alpha carbon coords
        QMap< int, QVector<CoordData> > coordsDataMap;
        //! These coords required to draw worms endings correctly
        QMap<int, QPair<Vector3D, Vector3D> > fakeAtomCoords;

        void createObjects3D();
        void createWormCoordsData();
        
        void drawWorms(); 

        void drawSecondaryStructure();

        QVector<Object3D* >  objects;

    public:
        
        WormsGLRenderer(const BioStruct3D& struc, const BioStruct3DColorScheme* s);
        
        ~WormsGLRenderer();
        
        void drawBioStruct3D();
        
        void updateColorScheme(const BioStruct3DColorScheme* s);
        
        RENDERER_FACTORY(WormsGLRenderer)

    };

} //namespace

#endif // _GB2_BIOSTRUCT3D_WORMS_RENDERER_H_
