##################################################################
# Unipro UGENE - Integrated Bioinformatics Suite
# Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
# All Rights Reserved
# 
#
#     This source code is distributed under the terms of the
#     GNU General Public License. See the files COPYING and LICENSE
#     for details.
##################################################################

include( ../../ugene_globals.pri )
UGENE_RELATIVE_DESTDIR = 'plugins/script'

TEMPLATE = lib
CONFIG +=thread debug_and_release warn_off
INCLUDEPATH += src
QT -= gui
QT += script xml
DEFINES+= _CRT_SECURE_NO_WARNINGS
TARGET = qtbindings_xml

!debug_and_release|build_pass {
    CONFIG(debug, debug|release) {
        TARGET = qtbindings_xmld
        DEFINES+=_DEBUG
        DESTDIR=../../_debug/plugins/script
        OBJECTS_DIR=_tmp/obj/debug
        MOC_DIR=_tmp/moc/debug
    }

    CONFIG(release, debug|release) {
        TARGET = qtbindings_xml
        DEFINES+=NDEBUG
        DESTDIR=../../_release/plugins/script
        OBJECTS_DIR=_tmp/obj/release/
        MOC_DIR=_tmp/moc/release
    }
}


win32 {
    QMAKE_CXXFLAGS_WARN_ON = -W3
    QMAKE_CFLAGS_WARN_ON = -W3
    QMAKE_MSVC_PROJECT_NAME=lib_3rd_qtbindings_xml
}

unix {
    target.path = $$UGENE_INSTALL_DIR/$$UGENE_RELATIVE_DESTDIR
    INSTALLS += target
}
