/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "Schema.h"
#include "WorkflowModel.h"

namespace GB2 {
namespace Workflow {

int Iteration::nextId() {
    static int id = 0;
    return id++;
}

QVariantMap Iteration::getParameters(ActorId id) const {
    QVariantMap map;
    QMapIterator< QPair<ActorId, QString>, QVariant> it(cfg);
    while (it.hasNext())
    {
        it.next();
        if (id == it.key().first) {
            map.insert(it.key().second, it.value());
        }
    }
    return map;
}

void Iteration::remap(QMap<ActorId, ActorId> map) {
    IterationCfg newCfg;
    QMapIterator< QPair<ActorId, QString>, QVariant> it(cfg);
    while (it.hasNext())
    {
        it.next();
        newCfg.insert(qMakePair(map.value(it.key().first), it.key().second), it.value());
    }
    cfg = newCfg;
}

void Schema::applyConfiguration(const Iteration& cfg, QMap<ActorId, ActorId> remap) {
    QMapIterator< QPair<ActorId, QString>, QVariant> it(cfg.cfg);
    while (it.hasNext())
    {
        it.next();
        ActorId id = it.key().first;
        //assert(remap.isEmpty() || remap.contains(id));
        if (remap.contains(id)) {
            id = remap.value(id);
        }
        Actor* actor = NULL;
        foreach(Actor* a, procs) {
            if (a->getId() == id) {
                actor = a;
                break;
            }
        }
        //assert(actor);
        if (actor)
        actor->setParameter(it.key().second, it.value());
    }
}

Schema::~Schema()
{
    if (deepCopy) {
        qDeleteAll(flows);
        flows.clear();
        qDeleteAll(procs);
        procs.clear();
    }
}
}//Workflow namespace
}//GB2namespace
