/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_LOAD_DOCUMENT_TASK_H_
#define _GB2_LOAD_DOCUMENT_TASK_H_

#include <core_api/Task.h>

#include <QtCore/QPointer>
#include <QtCore/QVariantMap>

namespace GB2 {

class Document;
class DocumentFormat;
class IOAdapterFactory;
class StateLock;
class LoadDocumentTask;

class GB2_COREAPI_EXPORT LoadUnloadedDocumentTask : public Task {
    Q_OBJECT
public:
	LoadUnloadedDocumentTask(Document* d);
    
	virtual void prepare();
	virtual ReportResult report();

    static QString getResourceName(Document* d);
   
    Document* getDocument() const; 
    
    static LoadUnloadedDocumentTask* findActiveLoadingTask(Document* d);

private:
    void clearResourceUse();

	class LoadDocumentTask* subtask;
	QPointer<Document>      unloadedDoc;
    QString                 resName;
};

class GB2_COREAPI_EXPORT LoadDocumentTask : public Task {
    Q_OBJECT
public:
	LoadDocumentTask(DocumentFormatId format, const QString& url, IOAdapterFactory* iof, const QVariantMap& hints = QVariantMap());
	~LoadDocumentTask();
	
	virtual void run();
	virtual ReportResult report();
    virtual void cleanup();

	Document* getDocument() const {return result;}
	Document* takeDocument() {Document* d = result; result = NULL; return d;}
    const QString& getUrl() const {return url;}

private:
	DocumentFormatId    format;
	const QString       url;
	IOAdapterFactory*   iof;
    QVariantMap         hints;
	Document*           result;
};

class GB2_COREAPI_EXPORT LoadUnloadedDocumentAndOpenViewTask : public Task {
    Q_OBJECT
public:
    LoadUnloadedDocumentAndOpenViewTask(Document* d);
    
protected:
    virtual QList<Task*> onSubTaskFinished(Task* subTask);

private:
    void clearResourceUse();

    class LoadUnloadedDocumentTask* loadUnloadedTask;
};

}//namespace

#endif
