/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CREATE_ANNOTATION_TASK_H_
#define _GB2_CREATE_ANNOTATION_TASK_H_

#include <core_api/Task.h>

#include <gobjects/AnnotationTableObject.h>

#include <QtCore/QPointer>

namespace GB2 {

class AnnotationTableObject;
class AnnotationData;

class GB2_COREAPI_EXPORT CreateAnnotationsTask : public Task {
    Q_OBJECT
public:
    //Adds annotations to the object. Waits object to be unlocked if needed
	CreateAnnotationsTask(AnnotationTableObject* o, const QString& group, SharedAnnotationData data);
	CreateAnnotationsTask(AnnotationTableObject* o, const QString& group, QList<SharedAnnotationData> data);

	virtual void prepare();

	ReportResult report();
	const QList<Annotation*>& getAnnotations() const {return annotations;}

private:
	QPointer<AnnotationTableObject> ao;
	QString groupName;
	QList<SharedAnnotationData> aData;
	QList<Annotation*> annotations;
};

}//namespace

#endif
