/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "CreateAnnotationTask.h"

#include <gobjects/GObjectUtils.h>
#include <core_api/DocumentModel.h>

namespace GB2 {


CreateAnnotationsTask::CreateAnnotationsTask(AnnotationTableObject* _ao, const QString& _g, QSharedDataPointer<AnnotationData> _data)
: Task(tr("Create annotations"), TaskFlags_NR_DWF), ao(_ao), groupName(_g)
{
	aData << _data;
}

CreateAnnotationsTask::CreateAnnotationsTask(AnnotationTableObject* _ao, const QString& _g, QList<QSharedDataPointer<AnnotationData> > _data) 
: Task(tr("Create annotations"), TaskFlags_NR_DWF), ao(_ao), groupName(_g)
{
	aData = _data;
}

void CreateAnnotationsTask::prepare() {
	if (ao.isNull()) {
		stateInfo.error = tr("object_removed");
		return;
	}
}

Task::ReportResult CreateAnnotationsTask::report() {
    if (ao->isStateLocked()) {
		return ReportResult_CallMeAgain;
	}
    
	foreach(SharedAnnotationData ad, aData) {
		Annotation* a = new Annotation(ad);
		annotations.append(a);
		ao->addAnnotation(a, groupName);
	}

	return ReportResult_Finished;
}


} // namespace
