/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_MSA_EDITOR_H_
#define _GB2_MSA_EDITOR_H_

#include <core_api/ObjectViewModel.h>
#include <core_api/LRegion.h>

#include <QtGui/QSplitter>
#include <QtGui/QListWidget>
#include <QtGui/QScrollBar>
#include <QtGui/QMenu>

namespace GB2 {

class MAlignmentObject;
class MSAEditorUI;
class MSAEditorSequenceArea;
class MSAEditorConsensusArea;
class MSAEditorNameList;

#define MSAE_MENU_COPY          "MSAE_MENU_COPY"
#define MSAE_MENU_EDIT          "MSAE_MENU_EDIT"
#define MSAE_MENU_ALIGN         "MSAE_MENU_ALIGN"
#define MSAE_MENU_ADVANCED      "MSAE_MENU_ADVANCED"


class GB2_COREAPI_EXPORT MSAEditor : public GObjectView {
    Q_OBJECT
public:
    MSAEditor(const QString& viewName, MAlignmentObject* obj);
    ~MSAEditor();

    virtual void buildStaticToolbar(QToolBar* tb);

    virtual void buildStaticMenu(QMenu* m);

    virtual Task* updateViewTask(const QString& stateName, const QVariantMap& stateData);

    virtual QVariantMap saveState();
    
    MAlignmentObject* getMSAObject() const {return msaObject;}

    const MSAEditorUI* getUI() const {return ui;}

    int getAlignmentLen() const;
    
    int getNumSequences() const;

protected slots:
    void sl_onContextMenuRequested(const QPoint & pos);

protected:
    virtual QWidget* createWidget();

private:
    void addCopyMenu(QMenu* m);
    void addEditMenu(QMenu* m);
    void addAlignMenu(QMenu* m);
    void addAdvancedMenu(QMenu* m);

    MAlignmentObject* msaObject;
    MSAEditorUI* ui;

};

class MSAEditorUI : public QWidget {
    Q_OBJECT

    //todo: make public accessors:
    friend class MSAEditorSequenceArea;
    friend class MSAEditorConsensusArea;
    friend class MSAEditorNameList;
    friend class MSAEditor;

public:
    MSAEditorUI(MSAEditor* editor);

private:
    MSAEditor*                  editor;
    QListWidget*                consList;
    MSAEditorNameList*          nameList;
    QSplitter*                  mainSplitter;
    MSAEditorSequenceArea*      seqArea;
    MSAEditorConsensusArea*     consArea;
    QScrollBar*                 shBar;
    QScrollBar*                 svBar;

};





}//namespace;

#endif
