/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WINDOW_STEP_SELECTOR_WIDGET_
#define _GB2_WINDOW_STEP_SELECTOR_WIDGET_

#include <QtGui/QDialog>
#include <QtGui/QSpinBox>
#include <QtGui/QDoubleSpinBox>
#include <QtGui/QGroupBox>
#include <core_api/LRegion.h>

namespace GB2 {

class GB2_COREAPI_EXPORT WindowStepSelectorWidget :  public QWidget {
    Q_OBJECT
public:
    WindowStepSelectorWidget(QWidget* p, const LRegion& winRange, int win, int step);
    QString validate() const;

    int getWindow() const;
    int getStep() const;

private:
    QSpinBox*   windowEdit;
    QSpinBox*   stepsPerWindowEdit;
};

class GB2_COREAPI_EXPORT MinMaxSelectorWidget : public QWidget {
	Q_OBJECT
public:
	MinMaxSelectorWidget(QWidget* p, double min, double max, bool enabled);
	QString validate() const;

	double getMin() const;
	double getMax() const;
	bool getState() const;

private:
	QGroupBox* minmaxGroup;
	QDoubleSpinBox* minBox;
	QDoubleSpinBox* maxBox;
};

class GB2_COREAPI_EXPORT WindowStepSelectorDialog : public QDialog {
    Q_OBJECT
public: 
    WindowStepSelectorDialog(QWidget* p, const LRegion& winRange, int win, int step, double min, double max, bool e);
    WindowStepSelectorWidget* getWindowStepSelector() const {return wss;}
	MinMaxSelectorWidget* getMinMaxSelector() const {return mms;}

private slots:
    void sl_onCancelClicked(bool);
    void sl_onOkClicked(bool);
private:
    WindowStepSelectorWidget* wss;
	MinMaxSelectorWidget* mms;
};

} // namespace

#endif
