/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_CREATE_ANNOTATION_WIDGET_CONTROLLER_H_
#define _GB2_CREATE_ANNOTATION_WIDGET_CONTROLLER_H_

#include <ui/ui_CreateAnnotationWidget.h>

#include <core_api/LRegion.h>
#include <core_api/DocumentModel.h>

#include <gobjects/AnnotationTableObject.h>

namespace GB2 {

class GObjectComboBoxController;


class GB2_COREAPI_EXPORT CreateAnnotationModel {
public:
	CreateAnnotationModel();

    GObjectReference        sequenceObjectRef;
    bool                    defaultIsNewDoc;

    bool                    hideLocation;
    bool                    hideAnnotationName;
	QString					groupName;
	SharedAnnotationData	data;

    QPointer<AnnotationTableObject>     annotationObject;
    QString                             newDocUrl;
};

class GB2_COREAPI_EXPORT CreateAnnotationWidgetController : public QObject, public Ui::CreateAnnotationWidget {
Q_OBJECT
public:
	
	CreateAnnotationWidgetController(CreateAnnotationModel* m, QObject* p);
	
	//returns error message or empty string if no error found;
	QString validate(); 

	QWidget* getWidget() const {return w;}
    CreateAnnotationModel*	getModel() const {return model;}

    void prepareAnnotationObject();

private slots:
	void sl_onNewDocClicked();
    void sl_onLoadObjectsClicked();

private:
	void updateModel();

	CreateAnnotationModel*	model;
	GObjectComboBoxController* occ;
	QWidget* w;

    QString GROUP_NAME_AUTO;
};


} // namespace

#endif
