/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_XML_TEST_UTILS_
#define _GB2_XML_TEST_UTILS_

#include <test_framework/GTest.h>
#include "XMLTestFormat.h"

namespace GB2 {


#define SIMPLE_XML_TEST_CONSTRUCT(ClassName, Run) \
    ClassName(XMLTestFormat* _tf, const QString& _name, GTest* _cp, \
        const GTestEnvironment* _env, const QList<GTest*>& _contexts, const QDomElement& _el) \
    : GTest(_name, _cp, _env, Run, _contexts){init(_tf, _el);} \


#define SIMPLE_XML_TEST_BODY(ClassName, Run) \
public:\
    SIMPLE_XML_TEST_CONSTRUCT(ClassName, Run) \
    void init(XMLTestFormat *tf, const QDomElement& el); \

    
#define SIMPLE_XML_TEST_BODY_WITH_FACTORY_AND_EXT(TestClass, TagName, Run) \
    SIMPLE_XML_TEST_BODY(TestClass, Run) \
    class TestClass##Factory : public XMLTestFactory { \
    public: \
        TestClass##Factory () : XMLTestFactory(TagName) {} \
        \
        virtual GTest* createTest(XMLTestFormat* tf, const QString& testName, GTest* cp, \
                    const GTestEnvironment* env, const QList<GTest*>& subtasks, const QDomElement& el) \
        { \
            return new TestClass(tf, testName, cp, env, subtasks, el); \
        }\
    };\
    \
    static XMLTestFactory* createFactory() {return new TestClass##Factory();}\


#define SIMPLE_XML_TEST_BODY_WITH_FACTORY(TestClass, TagName) \
    SIMPLE_XML_TEST_BODY_WITH_FACTORY_AND_EXT(TestClass, TagName, false)\
    
    
    
class XMLTestUtils {
public:
    static QList<XMLTestFactory*> createTestFactories();
};


//////////////////////////////////////////////////////////////////////////
// utility tasks

class XMLMultiTest : public GTest {
    Q_OBJECT
public:
    SIMPLE_XML_TEST_BODY_WITH_FACTORY(XMLMultiTest, "multi-test");
    ReportResult report();
};

} //namespace

#endif

