/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EMBL_GENBANK_ABSTRACT_DOCUMENT_H_
#define _GB2_EMBL_GENBANK_ABSTRACT_DOCUMENT_H_

#include <core_api/DocumentFormats.h>
#include <core_api/DocumentModel.h>

#include <QtCore/QStringList>
#include <gobjects/AnnotationTableObject.h>


namespace GB2 {

class IOAdapter;
class EMBLGenbankAbstractIDLine;
class EMBLGenbankAbstractHeader;


class GB2_COREAPI_EXPORT EMBLGenbankAbstractDocument : public DocumentFormat {
    Q_OBJECT
public:
    EMBLGenbankAbstractDocument(const DocumentFormatId& id, const QString& formatName, int maxLineSize, QObject* p);

    virtual DocumentFormatId getFormatId() const {return id;}

    virtual const QString& getFormatName() const {return formatName;}

    virtual QStringList getSupportedDocumentFileExtensions() {return extensions;}

    virtual Document* loadExistingDocument(IOAdapterFactory* io, const QString& url, TaskStateInfo& ti, const QVariantMap& fs);

    virtual bool isObjectOpSupported(const Document* d , DocumentFormat::DocObjectOp op, GObjectType t) const;

    virtual bool checkConstraints(const DocumentFormatConstraints& c) const;

    virtual bool isDataFormatSupported(const char* data, int size) const = 0;

    static const QString UNIMARK;
    static const QString UNKNOWN_OBJ_NAME;

    static const QByteArray AMINO_STRAND_QNAME;
    static const QByteArray AMINO_STRAND_QVAL_YES;
    static const QByteArray AMINO_STRAND_QVAL_NO;


    
protected:

    virtual void load(const QString& docUrl, IOAdapter* io, QList<GObject*>& objects, QVariantMap& fs, TaskStateInfo& si, QString& writeLockReason);
    virtual QString	genObjectName(QStringList& prevAnnotationNames, const EMBLGenbankAbstractHeader*, const QString& suffix, int n);
    virtual int     readMultilineQualifier(IOAdapter* io, char* cbuff, int maxSize, bool prevLineHasMaxSize);
    virtual SharedAnnotationData readAnnotation(IOAdapter* io, char* cbuff, int contentLen, int bufSize, TaskStateInfo& si, int offset);
    virtual void    readSequence(QByteArray& sequence, IOAdapter* io, TaskStateInfo& si);

    virtual EMBLGenbankAbstractIDLine*   readIdLine(const QString& line, TaskStateInfo& si) = 0;
    virtual EMBLGenbankAbstractHeader*	 readHeader(IOAdapter* io, TaskStateInfo& si) = 0;
    virtual QList<SharedAnnotationData>	 readAnnotations(IOAdapter* io, TaskStateInfo& si, int offset) = 0;
    
    
    DocumentFormatId id;
    QString     formatName;
    QStringList extensions;
    QByteArray  fPrefix;
    QByteArray  sequenceStartPrefix;
    int         maxAnnotationLineLen;
};

//////////////////////////////////////////////////////////////////////////
// header model

class GB2_COREAPI_EXPORT EMBLGenbankAbstractIDLine {
public:
    EMBLGenbankAbstractIDLine() : seqLen(0){}
    virtual ~EMBLGenbankAbstractIDLine(){}

    /** locus name */
    QString name;

    /** sequence len*/
    int	seqLen;

};


class EMBLGenbankAbstractHeader {
public:
    EMBLGenbankAbstractHeader() : idLine(NULL){};
    virtual ~EMBLGenbankAbstractHeader() {
        if (idLine!=NULL) {
            delete idLine;
        }
    }
    EMBLGenbankAbstractIDLine* idLine;
    QMap<QString, QString> tags;
};

}//namespace

#endif
