/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_DOCUMENT_FORMAT_UTILS_H_
#define _GB2_DOCUMENT_FORMAT_UTILS_H_

#include <core_api/LRegion.h>

#include <QtCore/QStringList>

//todo: move to separate header
#define MERGE_MULTI_DOC_GAP_SIZE_SETTINGS           "merge_gap"
#define MERGE_MULTI_DOC_SEQUENCE_SIZE_SETTINGS      "merge_size"

namespace GB2  {

class Document;
class DocumentFormat;
class DNAAlphabet;
class DNASequenceObject;
class GObject;
class MAlignment;

class GB2_COREAPI_EXPORT DocumentFormatUtils {
public:
    static DNASequenceObject* addSequenceObject(QList<GObject*>& objects, const QString& sequenceName, QByteArray& sequence, DNAAlphabet* al = NULL);

    /** if no docURL provided -> relations are not set*/
    static DNASequenceObject* addMergedSequenceObject(QList<GObject*>& objects, const QString& docUrl, const QStringList& contigs, 
                            QByteArray& mergedSequence, const QList<LRegion>& mergedMapping);

    static DNAAlphabet* findAlphabet(const QByteArray& arr);
    
    static QList<DNAAlphabet*> findAlphabets(const QByteArray& arr);

    static DNAAlphabet* findAlphabet(const QByteArray& arr, const QList<LRegion>& regionsToProcess);

    static void trySqueeze(QByteArray& a);

    static int getIntSettings(const QVariantMap& fs, const char* sName, int defVal);

    static void updateFormatSettings(QList<GObject*>& objects, QVariantMap& fs);

    static void addOffset(QList<LRegion>& location, int offset);

    // the best match goes first in the returned list
    static QList<DocumentFormat*> detectFormat(const QString& url);

    static void assignAlphabet(MAlignment& ma);

};

}//namespace
 
#endif
