/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_LOG_H_
#define _GB2_LOG_H_

#include "core_api.h"

#include <QtCore/QMetaType>
#include <QtCore/QTime>

namespace GB2 {

enum LogLevel { LogLevel_TRACE, LogLevel_DETAILS, LogLevel_INFO, LogLevel_ERROR, LogLevel_NumLevels};

class GB2_COREAPI_EXPORT LogMessage {
public:
	LogMessage() {}
    LogMessage(const QString& cat, LogLevel l, const QString& m) 
        : category(cat), level(l), text(m), time(QTime::currentTime()) {}

	QString	    category;
	LogLevel    level;
	QString     text;
    QTime       time;
};


class GB2_COREAPI_EXPORT LogCategory {
public:
	LogCategory(const QString& name);
	virtual ~LogCategory();

	void message(LogLevel level, const QString& msg);
    
    void trace(const QString& msg)  { message(LogLevel_TRACE, msg);}
    
    void details(const QString& msg)  { message(LogLevel_DETAILS, msg);}
    
    void info(const QString& msg)  { message(LogLevel_INFO, msg);}
	
    void error(const QString& msg)  { message(LogLevel_ERROR, msg);}
	
    const QString& getCategoryName() const {return categoryName;}

private:
	QString categoryName;
};

class GB2_COREAPI_EXPORT LogServer : public QObject {
	Q_OBJECT
	friend class LogCategory;
public:
	LogServer();
	static LogServer* getInstance();
	const QList<LogCategory*>& activeCategories() const {return categories;}

private:
	void message(const LogMessage& m) {emit si_message(m);}
	QList<LogCategory*> categories;

signals:
	void si_message(const LogMessage& m);
};

}//namespace

//TODO: support log category translation + use log category ids instead of the names in code
//TODO: support categories with multiple keys: like IO + Core Services

#define ULOG_CAT_USER_INTERFACE     "User Interface"
#define ULOG_CAT_CORE_SERVICES      "Core Services"
#define ULOG_CAT_IO                 "Input/Output"
#define ULOG_CAT_PERFORMANCE        "Performance"
#define ULOG_CAT_TASKS              "Tasks"
#define ULOG_CAT_SCRIPTS            "Scripts"
#define ULOG_CAT_ADV                "Sequence View"
#define ULOG_CAT_MSA                "MSA Editor"
#define ULOG_CAT_TEXT               "Text Editor"
#define ULOG_CAT_WD                 "Workflow Designer"

Q_DECLARE_METATYPE( GB2::LogMessage )


#endif

