#include "cs_mex.h"
/* x=L\sparse(b).  L must be sparse, real, and lower triangular.  b must be a
 * real sparse vector.  X is sparse.  Time taken is O(flop count), which may
 * be less than n, depending on L and b.
 *
 * This function works with MATLAB 7.1, but is not perfectly compatible with
 * the requirements of a MATLAB mexFunction.  X is returned unsorted.  Also,
 * this mexFunction temporarily modifies its input, L, by modifying L->p (in
 * the cs_dfs function) and then restoring it.  This could be corrected by
 * creating a copy of L->p (see cs_dmperm_mex.c), but this would take O(n)
 * time, destroying the O(flop count) time complexity of this function.
 */

void mexFunction
(
    int nargout,
    mxArray *pargout [ ],
    int nargin,
    const mxArray *pargin [ ]
)
{
    cs Lmatrix, Bmatrix, *L, *B, *X ;
    double *x ;
    int top, nz, p, *xi ;

    if (nargout > 1 || nargin != 2)
    {
	mexErrMsgTxt ("Usage: x = cs_splsolve (L,b)") ;
    }

    /* get inputs */
    L = cs_get_sparse (&Lmatrix, 1, 1, pargin [0]) ;
    B = cs_get_sparse (&Bmatrix, 0, 1, pargin [1]) ;
    cs_check (0, L->n, 1, 0, 1, 1, pargin [1]) ;

    xi = cs_malloc (2*L->n, sizeof (int)) ;
    x  = cs_malloc (L->n, sizeof (double)) ;

    top = cs_splsolve (L, B, 0, xi, x, NULL) ;

    X = cs_spalloc (L->n, 1, L->n-top, 1, 0) ;
    X->p [0] = 0 ;
    nz = 0 ;
    for (p = top ; p < L->n ; p++)
    {
	X->i [nz] = xi [p] ;
	X->x [nz++] = x [xi [p]] ;
    }
    X->p [1] = nz ;

    pargout [0] = cs_put_sparse (&X) ;

    cs_free (x) ;
    cs_free (xi) ;
}
