#include "cs_mex.h"
/* cs_lsolve: solve a lower triangular system L*x=b */
void mexFunction
(
    int nargout,
    mxArray *pargout [ ],
    int nargin,
    const mxArray *pargin [ ]
)
{
    cs Lmatrix, *L ;
    double *x, *b ;
    if (nargout > 1 || nargin != 2)
    {
	mexErrMsgTxt ("Usage: x = cs_lsolve(L,b)") ;
    }
    L = cs_get_sparse (&Lmatrix, 1, 1, pargin [0]) ;	    /* get L */
    b = cs_get_double (L->n, pargin [1]) ;		    /* get b */
    x = cs_put_double (L->n, b, &(pargout [0])) ;	    /* x = b */
    cs_lsolve (L, x) ;					    /* x = L\x */
}
