/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <QMenuBar>
#include <QToolBar>
#include <QMenu>
#include <QAction>
#include <QSpinBox>
#include <QMdiArea>
#include <QTextEdit>

#include "scriptwindow.h"
#include "tablewindow.h"
#include "infodialog.h"
//-----------------------------------------------------------------------------
//#include "xpm/preview.xpm"
#include "xpm/plot.xpm"
#include "xpm/size.xpm"
#include "xpm/smth.xpm"
#include "xpm/oper_d.xpm"
#include "xpm/oper_s.xpm"
#include "xpm/oper_a.xpm"
#include "xpm/oper_m.xpm"
#include "xpm/crop.xpm"
#include "xpm/tran.xpm"
#include "xpm/integr.xpm"
#include "xpm/diff.xpm"
#include "xpm/diff2.xpm"
#include "xpm/squize.xpm"
#include "xpm/sum.xpm"
#include "xpm/func.xpm"
#include "xpm/swap.xpm"
//-----------------------------------------------------------------------------
void ScriptWindow::makeDataMenu()
{
	QAction *a;
	QMenu *o, *oo;
	QToolBar *bb;

	dataMenu = menuBar()->addMenu(tr("&Data"));
	// file menu
	{
	bb = tbData[0] = new QToolBar(tr("File Operations"),this);
	addToolBar(Qt::TopToolBarArea, bb);	insertToolBarBreak(bb);
	o = dataMenu->addMenu(tr("&File"));
	a = new QAction(QPixmap(":/xpm/document-open.png"), tr("&Load data"), this);
	connect(a, SIGNAL(activated()), this, SLOT(loadData()));
	a->setToolTip(tr("Load data from file. Data will be deleted only\nat exit but UDAV will not ask to save it."));
	a->setShortcut(Qt::CTRL+Qt::SHIFT+Qt::Key_O);	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/document-import.png"), tr("&Import PNG"), this);
	connect(a, SIGNAL(activated()), this, SLOT(imprt()));
	a->setToolTip(tr("Import data from PNG picture with specified color scheme.\nData will be deleted only at exit but UDAV will not ask it saving."));
	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/document-save.png"), tr("&Save data"), this);
	connect(a, SIGNAL(activated()), this, SLOT(saveData()));
	a->setToolTip(tr("Save data to tab-separeted file."));
	a->setShortcut(Qt::CTRL+Qt::SHIFT+Qt::Key_S);	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/document-export.png"), tr("&Export PNG"), this);
	connect(a, SIGNAL(activated()), this, SLOT(exprt()));
	a->setToolTip(tr("Export data to PNG picture. The colors defined by \nspecified color scheme. The same as in 'dens' command."));
	o->addAction(a);	bb->addAction(a);
//	o->addSeparator();	bb->addSeparator();
//	a = new QAction(QPixmap(insert_xpm), tr("Insert as &list"), this);
//	connect(a, SIGNAL(activated()), this, SLOT(list()));
//	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(plot_xpm), tr("Plot &data"), this);
	connect(a, SIGNAL(activated()), this, SLOT(plot()));
	a->setToolTip(tr("Plot data in new script window. You may select the kind\nof plot, its style and so on."));
	o->addAction(a);	bb->addAction(a);
/*	a = new QAction(QPixmap(preview_xpm), tr("Pre&view"), this);	// TODO
	a->setShortcut(Qt::Key_F2);	a->setCheckable(true);
	connect(a, SIGNAL(toggled(bool)), infoDlg, SLOT(setVisible(bool)));
	connect(infoDlg, SIGNAL(finished(int)), a, SLOT(toggle()));
	a->setToolTip(tr("Open/close the preview/information window (F2).\nThis window show simple graphics and information about data."));
	o->addAction(a);	bb->addAction(a);*/
	}
	// size menu
	{
	bb = tbData[1] = new QToolBar(tr("Resize data"),this);
	addToolBar(Qt::TopToolBarArea, bb);
	o = dataMenu->addMenu(tr("&Sizes"));
	a = new QAction(QPixmap(":/xpm/document-new.png"), tr("&Create new"), this);
	connect(a, SIGNAL(activated()), this, SLOT(create()));
	a->setToolTip(tr("Recreate the data with new sizes and fill it by zeros (Ctrl+N)."));
	a->setShortcut(Qt::CTRL+Qt::Key_N);	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(size_xpm), tr("&Resize"), this);
	connect(a, SIGNAL(activated()), this, SLOT(reSize()));
	a->setToolTip(tr("Resize (interpolate) the data to specified sizes (Ctrl+R)."));
	a->setShortcut(Qt::CTRL+Qt::Key_R);	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(squize_xpm), tr("&Squeeze"), this);
	connect(a, SIGNAL(activated()), this, SLOT(squize()));
	a->setToolTip(tr("Keep only each n-th element of the data array."));
	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(crop_xpm), tr("Cro&p"), this);
	connect(a, SIGNAL(activated()), this, SLOT(crop()));
	a->setToolTip(tr("Crop the data edges. Useful to cut off the zero-filled area."));
	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(tran_xpm), tr("&Transpose"), this);
	connect(a, SIGNAL(activated()), this, SLOT(transp()));
	a->setToolTip(tr("Transpose data dimensions, like x<->y or x<->z and so on."));
	o->addAction(a);	bb->addAction(a);
	a = new QAction(tr("Re&arrange"), this);
	connect(a, SIGNAL(activated()), this, SLOT(rearrange()));
	a->setToolTip(tr("Rearrange data sizes without changing data values."));
	o->addAction(a);
	}
	// modify menu
	{
	bb = tbData[2] = new QToolBar(tr("Modify data"),this);
	addToolBar(Qt::TopToolBarArea, bb);
	o = dataMenu->addMenu(tr("&Modify"));

	a = new QAction(QPixmap(func_xpm), tr("By &formula"), this);
	connect(a, SIGNAL(activated()), this, SLOT(byformula()));
	a->setToolTip(tr("Change data values according to formula depended on 'x', 'y' and 'z'\nvariables. A set of special function is availible also."));
	a->setShortcut(Qt::CTRL+Qt::Key_M);	o->addAction(a);	bb->addAction(a);
	a = new QAction(tr("Fill in &range"), this);
	connect(a, SIGNAL(activated()), this, SLOT(inrange()));
	a->setToolTip(tr("Fill data equidistantly from one value to another."));
	o->addAction(a);
	a = new QAction(tr("&Normalize"), this);
	connect(a, SIGNAL(activated()), this, SLOT(norm()));
	a->setToolTip(tr("Normalize data so that its minimal\nand maximal values be in specified range."));
	o->addAction(a);
	a = new QAction(tr("Norm. s&lices"), this);
	connect(a, SIGNAL(activated()), this, SLOT(normsl()));
	a->setToolTip(tr("Normalize each data slice perpendicular to some direction\nso that its minimal and maximal values be in specified range."));
	o->addAction(a);
	a = new QAction(QPixmap(smth_xpm), tr("&Smooth data"), this);
	connect(a, SIGNAL(activated()), this, SLOT(smooth()));
	a->setToolTip(tr("Smooth data by one of 4 methods along specified direction(s)."));
	o->addAction(a);	bb->addAction(a);
	o->addSeparator();	bb->addSeparator();

	oo = dataMenu->addMenu(tr("&Operators"));
	a = new QAction(QPixmap(sum_xpm), tr("&Cum. sum"), this);
	connect(a, SIGNAL(activated()), this, SLOT(cumsum()));
	a->setToolTip(tr("Summate data values along specified direction(s)."));
	oo->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(integr_xpm), tr("&Integrate"), this);
	connect(a, SIGNAL(activated()), this, SLOT(integr()));
	a->setToolTip(tr("Integrate data values along specified direction(s)."));
	oo->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(diff_xpm), tr("&Differentiate"), this);
	connect(a, SIGNAL(activated()), this, SLOT(diff()));
	a->setToolTip(tr("Differentiate data values along specified direction(s)."));
	oo->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(diff2_xpm), tr("&Laplace"), this);
	connect(a, SIGNAL(activated()), this, SLOT(diff2()));
	a->setToolTip(tr("Double differentiate data values along specified direction(s)."));
	oo->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(swap_xpm), tr("&Swap"), this);
	connect(a, SIGNAL(activated()), this, SLOT(swap()));
	a->setToolTip(tr("Swap left and right data part along specified direction(s).\nThis operation is useful for data after Fourier transform."));
	oo->addAction(a);	bb->addAction(a);
	a = new QAction(tr("&Mirror"), this);
	connect(a, SIGNAL(activated()), this, SLOT(mirror()));
	a->setToolTip(tr("Mirror left and right data part along specified direction(s).\nThis operation do like index change from 'i' to 'n-i'."));
	oo->addAction(a);

	oo = dataMenu->addMenu(tr("&Algebraic"));
	a = new QAction(QPixmap(oper_a_xpm), tr("&Add"), this);
	connect(a, SIGNAL(activated()), this, SLOT(addto()));
	a->setToolTip(tr("Add a number to all data values."));
	oo->addAction(a);
	a = new QAction(QPixmap(oper_s_xpm), tr("&Subtract"), this);
	connect(a, SIGNAL(activated()), this, SLOT(subto()));
	a->setToolTip(tr("Subtract a number to all data values."));
	oo->addAction(a);
	a = new QAction(QPixmap(oper_m_xpm), tr("&Multiply"), this);
	connect(a, SIGNAL(activated()), this, SLOT(multo()));
	a->setToolTip(tr("Multiply all data values by a number."));
	oo->addAction(a);
	a = new QAction(QPixmap(oper_d_xpm), tr("&Divide"), this);
	connect(a, SIGNAL(activated()), this, SLOT(divto()));
	a->setToolTip(tr("Divide all data values by a number."));
	oo->addAction(a);

	oo = dataMenu->addMenu(tr("A&nother data"));
	a = new QAction(tr("&Sum of"), this);	oo->addAction(a);
	connect(a, SIGNAL(activated()), this, SLOT(sumof()));
	a = new QAction(tr("M&in of"), this);	oo->addAction(a);
	connect(a, SIGNAL(activated()), this, SLOT(minof()));
	a = new QAction(tr("M&ax of"), this);	oo->addAction(a);
	connect(a, SIGNAL(activated()), this, SLOT(maxof()));
	a = new QAction(tr("Momentum along &x"), this);	oo->addAction(a);
	connect(a, SIGNAL(activated()), this, SLOT(momentx()));
	a = new QAction(tr("Momentum along &y"), this);	oo->addAction(a);
	connect(a, SIGNAL(activated()), this, SLOT(momenty()));
	a = new QAction(tr("Momentum along &z"), this);	oo->addAction(a);
	connect(a, SIGNAL(activated()), this, SLOT(momentz()));
	a = new QAction(tr("&Histogram"), this);	oo->addAction(a);
	connect(a, SIGNAL(activated()), this, SLOT(hist()));
	}
	// navigation menu
	{
	bb = tbData[3] = new QToolBar(tr("Navigate data"),this);
	addToolBar(Qt::TopToolBarArea, bb);
	o = dataMenu->addMenu(tr("&Navigate"));
	a = new QAction(QPixmap(":/xpm/go-first.png"), tr("&First slice"), this);
	connect(a, SIGNAL(activated()), this, SLOT(first()));
	a->setToolTip(tr("Go to the first data slice for 3D data."));
	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/go-previous.png"), tr("&Prev. slice"), this);
	connect(a, SIGNAL(activated()), this, SLOT(prev()));
	a->setToolTip(tr("Go to the previous data slice for 3D data."));
	o->addAction(a);	bb->addAction(a);

	sb = new QSpinBox(this);
	bb->addWidget(sb);	sb->setRange(0,0);
	sb->setToolTip(tr("Go to the specified data slice for 3D data."));

	a = new QAction(tr("Go to slice"), this);
	connect(a, SIGNAL(activated()), this, SLOT(gosl()));
	a->setToolTip(tr("Go to the specified data slice for 3D data."));
	o->addAction(a);
	a = new QAction(QPixmap(":/xpm/go-next.png"), tr("Next slice"), this);
	connect(a, SIGNAL(activated()), this, SLOT(next()));
	a->setToolTip(tr("Go to the next data slice for 3D data."));
	o->addAction(a);	bb->addAction(a);
	a = new QAction(QPixmap(":/xpm/go-last.png"), tr("Last slice"), this);
	connect(a, SIGNAL(activated()), this, SLOT(last()));
	a->setToolTip(tr("Go to the last data slice for 3D data."));
	o->addAction(a);	bb->addAction(a);
	}
	subActivated(0);
}
//-----------------------------------------------------------------------------
void ScriptWindow::loadData()
{	if(activeWindow())	activeWindow()->load();	}
//-----------------------------------------------------------------------------
void ScriptWindow::saveData()
{	if(activeWindow())	activeWindow()->save();	}
//-----------------------------------------------------------------------------
void ScriptWindow::imprt()
{	if(activeWindow())	activeWindow()->imprt();	}
//-----------------------------------------------------------------------------
void ScriptWindow::exprt()
{	if(activeWindow())	activeWindow()->exprt();	}
//-----------------------------------------------------------------------------
void ScriptWindow::copy()
{	if(activeWindow())	activeWindow()->copy();		else	edit->copy();	}
//-----------------------------------------------------------------------------
void ScriptWindow::paste()
{	if(activeWindow())	activeWindow()->paste();	else	edit->paste();	}
//-----------------------------------------------------------------------------
void ScriptWindow::plot()
{	if(activeWindow())	activeWindow()->plot();	}
//-----------------------------------------------------------------------------
void ScriptWindow::list()
{	if(activeWindow())	activeWindow()->list();	}
//-----------------------------------------------------------------------------
void ScriptWindow::byformula()
{	if(activeWindow())	activeWindow()->byformula();	}
//-----------------------------------------------------------------------------
void ScriptWindow::inrange()
{	if(activeWindow())	activeWindow()->inrange();	}
//-----------------------------------------------------------------------------
void ScriptWindow::norm()
{	if(activeWindow())	activeWindow()->norm();	}
//-----------------------------------------------------------------------------
void ScriptWindow::normsl()
{	if(activeWindow())	activeWindow()->normsl();	}
//-----------------------------------------------------------------------------
void ScriptWindow::create()
{	if(activeWindow())	activeWindow()->create();	}
//-----------------------------------------------------------------------------
void ScriptWindow::reSize()
{	if(activeWindow())	activeWindow()->resize();	}
//-----------------------------------------------------------------------------
void ScriptWindow::squize()
{	if(activeWindow())	activeWindow()->squize();	}
//-----------------------------------------------------------------------------
void ScriptWindow::crop()
{	if(activeWindow())	activeWindow()->crop();	}
//-----------------------------------------------------------------------------
void ScriptWindow::transp()
{	if(activeWindow())	activeWindow()->transp();	}
//-----------------------------------------------------------------------------
void ScriptWindow::rearrange()
{	if(activeWindow())	activeWindow()->rearrange();	}
//-----------------------------------------------------------------------------
void ScriptWindow::smooth()
{	if(activeWindow())	activeWindow()->smooth();	}
//-----------------------------------------------------------------------------
void ScriptWindow::cumsum()
{	if(activeWindow())	activeWindow()->cumsum();	}
//-----------------------------------------------------------------------------
void ScriptWindow::integr()
{	if(activeWindow())	activeWindow()->integr();	}
//-----------------------------------------------------------------------------
void ScriptWindow::diff()
{	if(activeWindow())	activeWindow()->diff();	}
//-----------------------------------------------------------------------------
void ScriptWindow::diff2()
{	if(activeWindow())	activeWindow()->diff2();	}
//-----------------------------------------------------------------------------
void ScriptWindow::swap()
{	if(activeWindow())	activeWindow()->swap();	}
//-----------------------------------------------------------------------------
void ScriptWindow::mirror()
{	if(activeWindow())	activeWindow()->mirror();	}
//-----------------------------------------------------------------------------
void ScriptWindow::sumof()
{	if(activeWindow())	activeWindow()->sumof();	}
//-----------------------------------------------------------------------------
void ScriptWindow::maxof()
{	if(activeWindow())	activeWindow()->maxof();	}
//-----------------------------------------------------------------------------
void ScriptWindow::minof()
{	if(activeWindow())	activeWindow()->minof();	}
//-----------------------------------------------------------------------------
void ScriptWindow::momentx()
{	if(activeWindow())	activeWindow()->momentx();	}
//-----------------------------------------------------------------------------
void ScriptWindow::momenty()
{	if(activeWindow())	activeWindow()->momenty();	}
//-----------------------------------------------------------------------------
void ScriptWindow::momentz()
{	if(activeWindow())	activeWindow()->momentz();	}
//-----------------------------------------------------------------------------
void ScriptWindow::hist()
{	if(activeWindow())	activeWindow()->hist();	}
//-----------------------------------------------------------------------------
void ScriptWindow::addto()
{	if(activeWindow())	activeWindow()->addto();	}
//-----------------------------------------------------------------------------
void ScriptWindow::subto()
{	if(activeWindow())	activeWindow()->subto();	}
//-----------------------------------------------------------------------------
void ScriptWindow::divto()
{	if(activeWindow())	activeWindow()->divto();	}
//-----------------------------------------------------------------------------
void ScriptWindow::multo()
{	if(activeWindow())	activeWindow()->multo();	}
//-----------------------------------------------------------------------------
void ScriptWindow::first()
{	if(activeWindow())	activeWindow()->first();	}
//-----------------------------------------------------------------------------
void ScriptWindow::last()
{	if(activeWindow())	activeWindow()->last();	}
//-----------------------------------------------------------------------------
void ScriptWindow::next()
{	if(activeWindow())	activeWindow()->next();	}
//-----------------------------------------------------------------------------
void ScriptWindow::prev()
{	if(activeWindow())	activeWindow()->prev();	}
//-----------------------------------------------------------------------------
void ScriptWindow::gosl()
{	if(activeWindow())	activeWindow()->gosl();	}
//-----------------------------------------------------------------------------
TableWindow *ScriptWindow::activeWindow()
{	return dynamic_cast<TableWindow *>(mdi->activeSubWindow());	}
//-----------------------------------------------------------------------------
void ScriptWindow::setSlice(int k)
{	if(activeWindow())	activeWindow()->setSlice(k);	}
//-----------------------------------------------------------------------------
void ScriptWindow::setNz(int nz)	// TODO !!! connect to TableWindow::nzChanged() then active
{	sb->setMaximum(nz-1);	}
//-----------------------------------------------------------------------------
void ScriptWindow::subActivated(QMdiSubWindow *)
{
	TableWindow *p=0;
	TableWindow *t = activeWindow();
	dataMenu->setEnabled(t!=0);
	for(int i=0;i<4;i++)	tbData[i]->setVisible(t!=0);
	if(p)	{	disconnect(sb, 0, p, 0);	disconnect(this, 0, p, 0);	}
	if(t)
	{
		sb->setMinimum(0);	sb->setMaximum(t->nz-1);	sb->setValue(t->kz);
		connect(sb, SIGNAL(valueChanged(int)), this, SLOT(setSlice(int)));
		connect(t, SIGNAL(sliceChanged(int)), sb, SLOT(setValue(int)));
		connect(t, SIGNAL(nzChanged(int)), this, SLOT(setNz(int)));
		p=t;
	}
}
//-----------------------------------------------------------------------------
