/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GRAPHWINDOW_H
#define GRAPHWINDOW_H
//-----------------------------------------------------------------------------
#include <QMdiSubWindow>
//-----------------------------------------------------------------------------
class QMGLCanvas;
class QScrollArea;
class QSpinBox;
class QMenu;
class QTimer;
class QPopupMenu;
class QMainWindow;
class QTableWidget;
class InfoDialog;
class AnimParam;
class TableWindow;
class mglVar;
//-----------------------------------------------------------------------------
class GraphWindow : public QMdiSubWindow
{
Q_OBJECT
public:
	QMGLCanvas *mgl;
	GraphWindow(QWidget *wp=0);
	~GraphWindow();
	void setMGLFont(const QString &path);
	void animParseText(const QString &txt);
	void makeMenu(QMainWindow *wnd);
public slots:
	void closeEvent(QCloseEvent *);
signals:
	void save();
	void animPutText(const QString &);
	void statusBarMessage(const QString &);
private slots:
	void animText(const QString &);
	void printPlot();
	void nextSlide();
	void prevSlide();
	void animStart(bool st);
	void animSetup();
	void adjust();
	void pressF5();
	void pressF9();
private:
	bool gifOn, jpgOn;
	QScrollArea* sv;
	QSpinBox *tet, *phi;
	QMenu *menu;
	// animation
	QString animParam;
	int animPos;
	QTimer *timer;
	AnimParam *animDialog;
	QMenu *popup;
	QPrinter *printer;
};
//-----------------------------------------------------------------------------
class MemoryWindow : public QMdiSubWindow
{
Q_OBJECT
public:
	MemoryWindow(QWidget *wp=0);
	~MemoryWindow();
	void makeMenu(QMainWindow *wnd);
	TableWindow *newWindow(mglVar *v=0);
public slots:
	void refresh();		///< refresh list of variables
	void closeEvent(QCloseEvent *);
signals:
	void save();
	void animPutText(const QString &);
	void statusBarMessage(const QString &);
private slots:
	void newTable();
	void editData(int n=-1);
	void infoData();
	void delAllData();
	void delData();
	void tableClicked(int row, int col);
	void tableDClicked(int row, int col);
private:
	InfoDialog *infoDlg;	///< Data preview and information
	QTableWidget *tab;
	int colSort;
};
#endif // GRAPHWINDOW_H
//-----------------------------------------------------------------------------
