#!/bin/bash

DEV=${1:?Missing device name}
VIRTIP="10.1.200.50/27"

IPCMD=/sbin/ip
LOGGER=/usr/bin/logger

[ -x $LOGGER ] || exit 1

if [ ! -x $IPCMD ] ; then
    $LOGGER -i -t ucarp-vipdown "ERROR: $IPCMD missing"
    exit 1
fi

$IPCMD addr del $VIRTUP dev $DEV

$LOGGER -i -t ucarp-vipdown "Entering BACKUP state for $VIRTUP"

RETVAL=$?

if [ $RETVAL != 0 ] ; then
    $LOGGER -i -t ucarp-vipdown "Failed to remove virt $VIRTIP, dev $DEV"
fi
