package snappy

import (
	. "launchpad.net/gocheck"
)

// systemd's testsuite
type DBusTestSuite struct {
	busName string
}

var _ = Suite(&DBusTestSuite{})

func (s *DBusTestSuite) SetUpTest(c *C) {
	s.busName = "foo.bar.baz"
}

const expectedBusPolicy = `<?xml version="1.0"?> <!--*-nxml-*-->
<!DOCTYPE busconfig PUBLIC "-//freedesktop//DTD D-BUS Bus Configuration 1.0//EN"
        "http://www.freedesktop.org/standards/dbus/1.0/busconfig.dtd">

<!--
  This file is autogenerated by snappy
-->

<busconfig>
        <policy user="root">
                <allow own="foo.bar.baz"/>
                <allow send_destination="foo.bar.baz"/>
        </policy>

        <policy context="default">
                <allow send_destination="foo.bar.baz"/>
        </policy>
</busconfig>
`

func (s *DBusTestSuite) TestGenBusPolicyFile(c *C) {
	generated, err := genBusPolicyFile(s.busName)
	c.Assert(err, IsNil)
	c.Assert(generated, Equals, expectedBusPolicy)
}

func (s *DBusTestSuite) TestGenBusPolicyFileGood(c *C) {
	goodnames := []string{
		"foo.bar",
		"foo.bar.baz",
		"foo-bar.baz",
		"foo_bar.baz",
		"foo-bar0.ba1z.q2ux.3norf",
	}

	for _, b := range goodnames {
		err := verifyBusName(b)
		c.Assert(err, IsNil)
	}
}
func (s *DBusTestSuite) TestGenBusPolicyFileBad(c *C) {
	badnames := []string{
		"",
		"foo",
		".foo",
		"foo.",
		"foo.bar.",
		".foo.bar",
		"_foo.bar",
		"-foo.bar",
		":1:234",
		"foo.bar.b@d",
	}

	for _, b := range badnames {
		err := verifyBusName(b)
		c.Assert(err, NotNil)
	}
}
