
#include <stdio.h>
#include "umserver.hpp"
#include "umsflow.hpp"
#include <X11/Xatom.h>
#include <X11/Xmu/WinUtil.h>
using namespace std;


/* ==================================================== ======== ======= */
// trouver position de win dans root.
// input:  win
// output: pos.rx, pos.ry  (pos.win = win et le reste a 0)

bool UMServer::locateWin(Window win, UMSpos& pos) {
  int x, y;
  unsigned int win_width, win_height, win_border, win_depth;
  Window root_win = None;
  Window win_child = None;

  pos.win = None;
  pos.winsock = -1;
  pos.wx = pos.wy = 0;
  pos.rx = pos.ry = 0;

  // !NB: XGetGeometry ne donne pas les coords absolues dans le cas des Shells
  // car ceux-ci sont inclus dans une fenetre intermediaire cree par le WM

  if (XGetGeometry(xdisplay, win, &root_win,  
		   &x, &y, &win_width, &win_height, 
		   &win_border, &win_depth)

      && XTranslateCoordinates(xdisplay, /*src*/win, /*dst*/root_win,
			       0, 0, &x, &y, &win_child)) {
    pos.win = win;
    pos.rx = x;
    pos.ry = y;
    return true;
  }
  else return false;
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
// trouver subwindow de win contenant le point (rx,ry).
// input:  win et point (rx,ry) dans root
// output: pos.win = subwindow trouvee ou win et coords = pos.{rx,ry,wx,wy}

bool UMServer::locatePoint(Window win, int rx, int ry, UMSpos& pos) {
  pos.win = None;
  pos.winsock = -1;
  pos.wx = pos.wy = 0;
  pos.rx = rx;
  pos.ry = ry;

  Window win_child = None;
  int x_in_win, y_in_win;
    
  // trouver la subwindow de win qui contient rx,ry 
  // et coords dans cette subwindow

  while (XTranslateCoordinates(xdisplay, /*src*/xrootwin, /*dst*/win,
			       rx, ry, &x_in_win, &y_in_win, &win_child)
	 ) {
    pos.win = win;
    pos.wx = x_in_win;
    pos.wy = y_in_win;
      
    if (win_child == None) break;
    else win = win_child;
  }

  return (pos.win != None);
}
/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
// trouver window de root contenant le point (rx,ry).
// input:  point (rx,ry) dans root
// output: pos.win = window trouvee et coords = pos.{rx,ry,wx,wy}

bool UMServer::locatePoint(int rx, int ry, UMSpos& pos) {
  Window root_win = None;
  int x, y;
  unsigned int width, height, border, depth;

  pos.win = None;
  pos.winsock = -1;
  pos.wx = pos.wy = 0;
  pos.rx = rx;
  pos.ry = ry;

  // !ATT: cette liste ne doit contenir que les window filles de xrootwin
  // (cad les window du WM qui contiennent celles des applis
  // ou les window override_redirect des menus)

  for (list<UMSwin*>::iterator k = root_children.begin(); 
       k != root_children.end(); 
       k++) {
    
    // !ATT: x et y sont relatifs a la parent window. il ne faut donc
    // considerer que les filles de root_win (ce qui est le cas ici)
    // sinon il faudrait translater les coords par XTranslateCoordinates

    if (XGetGeometry(xdisplay, (*k)->win, &root_win,  
		     &x, &y, &width, &height, &border, &depth)
	&& root_win == xrootwin      // tjrs vrai si 1 seul screen
	&& rx >= x && rx < int(x + width)
	&& ry >= y && ry < int(y + height)
	) {

      // trouver la subwindow de root_children[k] qui contient rx,ry 
      // et coords dans cette subwindow

      Window win = (*k)->win;
      Window win_child = None;
      int x_in_win, y_in_win;
      pos.ptr_in_uwin = ((*k)->ubit_props != null);
          
      while (XTranslateCoordinates(xdisplay, /*src*/root_win, /*dst*/win,
				   rx, ry, &x_in_win, &y_in_win, &win_child)) {
	pos.win = win;
	pos.wx = x_in_win;
	pos.wy = y_in_win;
	if (win_child == None) break;
	else win = win_child;
      }
    }
  }
  
  return (pos.win != None);
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */

bool UMServer::locatePointer(const UMSmouseFlow& flow, UMSpos& pos) {
  if (flow.getID() == 0) {
    // !ATT: suppose le warping du X pointer
    return locateXpointer(pos);
  }
  else { 
    return locatePoint(flow.getX(), flow.getY(), pos);
  }
}

/* ==================================================== ======== ======= */

bool UMServer::isPointer(Window win) {
  for (unsigned int f = 0; f < eflows.size(); f++) {
    if (eflows[f]->getPointer() == win) return true;
  }
  return false;
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */

bool UMServer::locateXpointer(UMSpos& pos) {
  int root_x = 0, root_y = 0;
  int x_in_win, y_in_win;
  unsigned int mask;
  Window root_win = None;
  Window win = xrootwin;
  Window win_child = None;

  pos.win = None;
  pos.winsock = -1;
  pos.wx = pos.wy = 0;
  pos.rx = pos.ry = 0;

  while (XQueryPointer(xdisplay, win, &root_win, &win_child,
		       &root_x, &root_y, &x_in_win, &y_in_win, &mask)) {
    pos.win = win;
    pos.wx = x_in_win;
    pos.wy = y_in_win;
    pos.rx = root_x;
    pos.ry = root_y;

    if (win_child == None || win_child == win) break;
    else win = win_child;
  }

  return (pos.win != None);
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */

UMSwin::~UMSwin() {
  if (command_argv) XFreeStringList(command_argv);
  if (ubit_props) XFree(ubit_props);
}

UMSwin::UMSwin(Window _win, Window _client_win,
	       int _command_argc, char** _command_argv,
	       char* _ubit_props, int _winsock) {
  win          = _win;
  client_win   = _client_win;
  command_argc = _command_argc;
  command_argv = _command_argv;
  ubit_props   = _ubit_props;
  winsock      = _winsock; 
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */

const UMSwin* UMServer::searchWin(UMSwinList& wl, Window win) {
  for (UMSwinList::iterator k = wl.begin(); k != wl.end(); k++) {
    if ((*k)->win == win) return *k;
  }
  return null;
}

const UMSwin* UMServer::searchWinCommand(UMSwinList& wl, const char* pattern) {
 for (UMSwinList::iterator k = wl.begin(); k != wl.end(); k++) {
    //if ((*k)->name && strstr((*k)->name, pattern)) return *k;
 }
  return null;
}

// NB: considere la version courante du wname (via XFetchName) laquelle
// peut changer si modifiee par l'application (par ex. Mozilla, etc.)

const UMSwin* UMServer::searchWinName(UMSwinList& wl, const char* pattern) {
  if (!pattern || !*pattern) return null;
 
 for (UMSwinList::iterator k = wl.begin(); k != wl.end(); k++) {
    bool found = false;
    char* wname = null;

    // necessaire sous certains systemes comme MacOS sinon on ne recupere
    // pas la bonne window
    Window w2 = XmuClientWindow(xdisplay, (*k)->win);
    
    //if (XFetchName(xdisplay, (*k)->win, &wname)
    if (w2 != None && XFetchName(xdisplay, w2, &wname)
        && wname && strstr(wname, pattern)) {
      found = true;
    }
    
    if (wname) XFree(wname);
    if (found) return *k;
  }
  return null;
}

UMSwinList::iterator UMServer::searchWinPos(UMSwinList& wl, Window win) {
  for (UMSwinList::iterator k = wl.begin(); k != wl.end(); k++) {
    if ((*k)->win == win) return k;
  }
  return wl.end(); // not found
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */

bool UMServer::addWin(UMSwinList& wl, Window win, bool init_wm, int sock) {
  // list<Window>::iterator above0 = 
  //  find(root_children.begin(), root_children.end(), e.xconfigure.above);
    
  UMSwinList::iterator k = searchWinPos(wl, win);     // verif pas deja la

  if (k != wl.end()) return false;  // deja dans la liste
  else {                            // ajouter a la fin
    Window client_win = None;
    int command_argc = 0;
    char** command_argv = null;
    unsigned char* ubit_win_prop = null;

    if (init_wm) {
      client_win = XmuClientWindow(xdisplay, win);

      XGetCommand(xdisplay, client_win, &command_argv, &command_argc);

      long req_offset = 0;
      long req_length = XMaxRequestSize(xdisplay);
      Atom type;
      int format;
      unsigned long nitems = 0, bytes_after = 1;

      // XGetWindowProperty always allocates one extra byte in prop_return
      // (even if the property is zero length) and sets it to zero so that
      // simple properties consisting of characters do not have to be
      // copied into yet another string before use.
      
      //Bool req_stat = 
      XGetWindowProperty(xdisplay, client_win, UBIT_WINDOW,
			 req_offset, req_length,
			 False,        // dont delete property
			 XA_STRING,    // req_type
			 &type, &format, &nitems, &bytes_after,
			 &ubit_win_prop);
      /*
      if (req_stat == Success && ubit_win_prop != null) {
        cerr  << "UbitWindowProp"
        << " type " << type << " format " << format << " nitems " << nitems
        << " prop " << int(ubit_win_prop) << "='" << ubit_win_prop <<"'"
        << endl;
	//if (nitems_return > 0 && type_return == XA_STRING && format_return == 8) ;
      }
      */
    }

    wl.push_back(new UMSwin(win, client_win, command_argc, command_argv,
			    (char*)ubit_win_prop, -1));
    return true;
  }
}

bool UMServer::removeWin(UMSwinList& wl, Window win) {
  UMSwinList::iterator k = searchWinPos(wl, win);

  if (k == wl.end()) return false;  // pas dans la liste
  else {                            // enlever
    delete *k;
    wl.erase(k);
    return true;
  }
}

void UMServer::moveWin(UMSwinList& wl, 
		       UMSwinList::iterator& from, 
		       const UMSwinList::iterator& to) {
  // on transfere l'objet pointe de from a to
  // on evite ainsi une creation et une destruction d'objet
  wl.insert(to, *from);
  *from = null;          // from ne pointe plus sur rien
  wl.erase(from);
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
/*
bool UMServer::addWin(Window win, int sock) {
  for (unsigned int k = 0; k < wins.size(); k++) {
    if (wins[k].win == win) return false;
  }

  wins.push_back(UMSwin(win, sock));
  return true;
}

void UMServer::removeWin(Window win) {
  for (unsigned int k = 0; k < wins.size(); k++) 
    if (wins[k].win == win) {
      wins.erase(wins.begin() + k);
      k--;
    }
}
// returns the socket or -1
int UMServer::searchWin(Window win) {
  for (unsigned int k = 0; k < wins.size(); k++) {
    if (wins[k].win == win) return wins[k].winsock;
  }
  return -1;
}
*/

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
// NB: peut etre appele plusieurs fois pour re-synchronisation eventuelle

void UMServer::retrieveWindows() {
  Window root_win = None;
  Window parent_win = None;
  Window* windows = NULL;
  unsigned int window_count = 0;

  root_children.clear();

  // The children are listed in current stacking order, from bottom-most 
  // (first) to top-most (last).

  if (XQueryTree(xdisplay, xrootwin, &root_win, &parent_win,
                 &windows, &window_count)
      && window_count != 0 && windows != null) {

    XWindowAttributes wattr;

    for (unsigned int k = 0; k < window_count-1; k++) {
      if (XGetWindowAttributes(xdisplay, windows[k], &wattr)
	  && wattr.map_state == IsViewable
	  ) {
	// att: ne pas mettre les pointer wins dans la liste !
	if (!isPointer(windows[k]))
	  addWin(root_children, windows[k], true, -1); //init_wname, sock=-1
      }
    }
    XFree(windows);
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UMServer::showWindows() {
  Window root_win = None;
  int win_x, win_y;
  unsigned int win_width, win_height;
  unsigned int win_border;
  unsigned int win_depth;

  for (list<UMSwin*>::iterator k = root_children.begin(); 
       k != root_children.end(); 
       k++) {
    if (XGetGeometry(xdisplay, (*k)->win,
		     &root_win,  &win_x, &win_y, 
		     &win_width, &win_height, 
		     &win_border, &win_depth)) {

      showWindowName((*k)->win);
      cerr << " / x,y = " << win_x << " " << win_y 
	   << " / w,h = " << win_width << " " << win_height << endl;
    }
  }
}

void UMServer::showWindowName(Window win) {
  
  win = XmuClientWindow(xdisplay, win); // !!

  char hex[20];
  sprintf(hex, "%lx", win);
  cerr << "win: " << win << " 0x"<<hex;
  char* window_name = NULL;

  if (XFetchName(xdisplay, win, &window_name))
    cerr << " / name: " << (window_name ?  window_name : "Null");
  else
    cerr << " / no name ";
  if (window_name) XFree(window_name);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
