/* ==================================================== ======== ======= *
*
*  uumode.cpp
*  Ubit Project [Elc][2003]
*  Author: Eric Lecolinet
*
*  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
*
*  (C) 1999-2003 Eric Lecolinet @ ENST Paris
*  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
*
* ***********************************************************************
* COPYRIGHT NOTICE :
* THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE
* IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
* YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU
* GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION;
* EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
* SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
* ***********************************************************************
*
* ==================================================== [Elc:03] ======= *
* ==================================================== ======== ======= */

//pragma ident	"@(#)uumode.cpp	ubit:03.04.02"
#include <iostream>
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucond.hpp>
#include <uctrl.hpp>
#include <ugroup.hpp>
using namespace std;

UMode UMode::selected(UCONST,   SELECTED, true);
UMode UMode::unselected(UCONST, SELECTED, false);
//UMode UMode::enabled(UCONST,    ENABLED, true);
//UMode UMode::disabled(UCONST,   ENABLED, false);

UMode UMode::canArm(UCONST,     CAN_ARM, true);

//NOTE: canSelect automatically implies canArm
UMode UMode::canSelect(UCONST, CAN_SELECT|CAN_ARM, true);
UMode UMode::enterHighlight(UCONST,  ENTER_HIGHLIGHT, true);
UMode UMode::actionHighlight(UCONST, ACTION_HIGHLIGHT, true);

//UMode UMode::enterHighborder(UCONST, ENTER_HIGHBORDER, true);
//UMode UMode::actionHighborder(UCONST,ACTION_HIGHBORDER, true);
//UMode UMode::actionWatch(UCONST,     ACTION_WATCH, true);

UMode UMode::canDrag1(UCONST, CAN_DRAG1, true);
UMode UMode::canDrag2(UCONST, CAN_DRAG2, true);
UMode UMode::canDrop(UCONST, CAN_DROP, true);

UMode UMode::ignoreEvents(UCONST|IGNORE_EVENTS, 0, true);

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UMode::UMode(u_modes b_modes) {
  bmask  = b_modes;
  bmodes = b_modes;
  cmask  = 0;
  cmodes = 0;
}

UMode::UMode(u_modes b_modes, u_modes c_modes, bool onoff) {
  bmask = b_modes;
  cmask = c_modes;

  if (onoff) {
    bmodes = b_modes;
    cmodes = c_modes;
  }
  else {
    // ATTENTION: certains modes sont propres au UMode
    // et ne doivent surtout PAS ETRE PROPAGES aux parents
    bmodes = b_modes & UMode::DONT_PROPAGATE;
    cmodes = 0;
  }
}

void UMode::addingTo(ULink *selflink, UGroup *parent) {
UBrick::addingTo(selflink, parent);
  setParentModes(parent);
}

void UMode::removingFrom(ULink *selflink, UGroup *parent) {
  //.... enelver le mode!!!
UBrick::removingFrom(selflink, parent);
}

/* ==================================================== ======== ======= */
//NOTE: this function does not copy modes that are specific to its
//UMode argument (such as UCONST, UREF, etc.)
// !!!ATTENTION: PROBLEME
// setModes() pose probleme avec select/unselect car ce n'est pas un mode
// qu'il faut propager au parent mais juste un referent pour le UOn
// (pour l'instant c'est regle en ne rajoutant pas ces modes et
// en testant directement l'egalite des UOn dans fire() et match()

void UMode::setParentModes(UCtrl *p/*parent*/) const {
  // B modes
  // ATTENTION: certains modes (UMode::CANT_DEL etc...) sont propres
  // a l'objet 'm' et ne doivent surtout PAS ETRE PROPAGES aux parents
  u_modes mod = bmodes & ~UMode::DONT_PROPAGATE;
  u_modes msk = bmask  & ~UMode::DONT_PROPAGATE;

  p->bmodes = p->bmodes |  (mod & msk);    //on_mask;
  p->bmodes = p->bmodes & ~(mod ^ msk);    //off_mask;

  // C modes
  p->cmodes = p->cmodes |  (cmodes & cmask);    //on_mask;
  p->cmodes = p->cmodes & ~(cmodes ^ cmask);    //off_mask;
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

