#include <ubit/ubit.hpp>
#include <ubit/ext/umove.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UFloatingbox::UFloatingbox(const UArgs& a) :
UBox(a), ppos(new UPos()) {
  addAttr(*ppos);
}

UFloatingbox::UFloatingbox(u_pos x, u_pos y, const UArgs& a) :
UBox(a), ppos(new UPos(x,y)) {
  addAttr(*ppos);
}

UFloatingbox::UFloatingbox(UPos& p, const UArgs& a) :
UBox(a), ppos(p) {
  addAttr(*ppos);
}

UFloatingbox& ufloatingbox(const UArgs& a) {
  return *new UFloatingbox(a);
}
UFloatingbox& ufloatingbox(u_pos x, u_pos y, const UArgs& a) {
  return *new UFloatingbox(x, y, a);
}

/* ==================================================== ======== ======= */

void UFloatingbox::move(u_pos x, u_pos y)  {ppos->set(x, y);}
void UFloatingbox::move(const UPos& p)     {*ppos = p;}
void UFloatingbox::setX(u_pos x)           {ppos->setX(x);}
void UFloatingbox::setY(u_pos y)           {ppos->setY(y);}

void UFloatingbox::where(u_pos &x, u_pos &y) const {
  x = ppos->getX(); y = ppos->getY();
}

u_pos UFloatingbox::getX() const {return ppos->getX();}
u_pos UFloatingbox::getY() const {return ppos->getY();}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== ======== ======= */

