//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Philipp E. Lim 1996
// 
// uDeadlineMonotonic1.cc -- 
// 
// Author           : Philipp E. Lim and Ashif S. Harji
// Created On       : Fri Oct 27 08:25:33 2000
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Oct 10 11:13:26 2005
// Update Count     : 20
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 

#define __U_KERNEL__
#include <uC++.h>
#include <uDeadlineMonotonic1.h>


#include <uAssert.h>
//#include <uDebug.h>


void uDeadlineMonotonic1::addInitialize( uSequence<uBaseTaskDL> &TaskList ) {
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uDeadlineMonotonic1 &)0x%p.addInitialize: enter\n" );
#endif // __U_DEBUG_H__

    uBaseTask &t = TaskList.tail()->uGet();

    uPIHeap *PIHptr = dynamic_cast<uPIHeap *>(t.uPIQ);
    if ( PIHptr == NULL ) {
	uAbort("(uDeadlineMonotonic1 &)0x%p.addInitialize : Task 0x%p has incorrect uPIQ type.", this, &t );
    } // if

    int queueNum = PIHptr->head();
    int priority = PIHptr->uGetHighestPriority();
    uRealTimeBaseTask *rbt;
    uPeriodicBaseTask *pbt;
    uSporadicBaseTask *sbt;

    if ( ( rbt = dynamic_cast<uRealTimeBaseTask *>(&t) ) == NULL ) { 
#ifdef __U_DEBUG_H__
	uDebugPrt( "(uDeadlineMonotonic1 &)0x%p.addInitialize: exit1\n" );
#endif // __U_DEBUG_H__
	uSetBasePriority( t, INT_MAX );			// set to a large number

	if ( queueNum == -1 ) {
	    uSetActivePriority( t, t );
	} else {
	    uSetActivePriority( t, priority );
	} // if
    } else if ( ( pbt = dynamic_cast<uPeriodicBaseTask *>(&t) ) != NULL ) {
	uSetBasePriority( t, (int)(pbt->uGetPeriod().nanoseconds() / 1000000) );
	if ( queueNum == -1 ) {
	    uSetActivePriority( *pbt, t );
	} else {
	    uSetActivePriority( *pbt, priority );
	} // if
    } else if ( ( sbt = dynamic_cast<uSporadicBaseTask *>(&t) ) != NULL ) {
	uSetBasePriority( t, (int)(sbt->uGetFrame().nanoseconds() / 1000000) );
	if ( queueNum == -1 ) {
	    uSetActivePriority( *sbt, t );
	} else {
	    uSetActivePriority( *sbt, priority );
	} // if
    } else {						// only uRealtime
	uSetBasePriority( t, (int)(rbt->uGetDeadline().nanoseconds() / 1000000) );
	if ( queueNum == -1 ) {
	    uSetActivePriority( (uRealTimeBaseTask &)t, t );
	} else {
	    uSetActivePriority( (uRealTimeBaseTask &)t, priority );
	} // if
    } // if

    // must assign a queue if none already assigned increment count.  do linear
    // search checking priority values.
    int tpri = uGetBasePriority( t );
    bool flag = false;

    for ( int i = 0; i < num_priorities; i += 1 ) {
	if ( tpri == uObjects[i].priority ) {
	    flag = true;
	    uSetBaseQueue( t, i);
	    if ( queueNum == -1 ) {
		uSetActiveQueue( t, i );		// should have at least t's serial on queue by now
	    } else {
		uSetActiveQueue( t, queueNum );		// should have at least t's serial on queue by now
	    } // if
	    break;
	} // if
    } // for 

    if ( ! flag ) {
	num_priorities += 1;
	if ( num_priorities <= __U_MAX_NUMBER_PRIORITIES__ ) {
	    uObjects[num_priorities - 1].priority = tpri;
	    uSetBaseQueue( t, num_priorities - 1 );
	    if ( queueNum == -1 ) {
		uSetActiveQueue( t, num_priorities - 1 ); // should have at least t's serial on queue by now
	    } else {
		uSetActiveQueue( t, queueNum );
	    } // if
	} else {
	    uAbort( "(uDeadlineMonotonic1 &)0x%p.addInitialize : Cannot schedule task as more priorities are needed than current limit of %d.",
		    this, __U_MAX_NUMBER_PRIORITIES__ );
	} // if
    } // if
} // uDeadlineMonotonic1::addInitialize


void uDeadlineMonotonic1::removeInitialize( uSequence<uBaseTaskDL> & ) {
    // Although removing a task may leave a hole in the priorities, the hole
    // should not affect the ability to schedule the task or the order the
    // tasks execute. Therefore, no rescheduling is performed.
    
//	addInitialize( TaskList );
} // uDeadlineMonotonic1::removeInitialize


void uDeadlineMonotonic1::uRescheduleTask( uBaseTaskDL *TaskNode, uBaseTaskSeq &TaskList ) {
    //verCount += 1;
    TaskList.remove( TaskNode );
    TaskList.addTail( TaskNode );
    addInitialize( TaskList );
} // uDeadlineMonotonic1::uRescheduleTask


// Local Variables: //
// compile-command: "gmake install" //
// End: //
