//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Peter A. Buhr 1998
// 
// EHM3.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Tue Oct 27 21:24:48 1998
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Nov 21 15:25:35 2005
// Update Count     : 41
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::osacquire;
using std::endl;

_ResumeEvent R1 {
  public:
	int &i; char &c;
	R1( int &i, char &c ) : i( i ), c( c ) {}
};

_ResumeEvent R2 {};

_DualEvent R3 {};


void f( int x, char y ) {
	osacquire( cout ) << "enter f, x:" << x << " y:" << y << endl;
	_Resume R2();
	osacquire( cout ) << "exit f, x:" << x << " y:" << y << endl;
}
void g( int &x, char &y ) {
	osacquire( cout ) << "enter g, x:" << x << " y:" << y << endl;
	_Resume R1( x, y );
	osacquire( cout ) << "exit g, x:" << x << " y:" << y << endl;
}

void rtn1( R1 &r ) {
	osacquire( cout ) << "rtn1" << endl;
	r.i = 1; r.c = 'b';
}

struct Rtn2 {
	int &i; char &c;
	Rtn2( int &i, char &c ) : i( i ), c( c ) {}
	void operator()( R2 &r ) {
		osacquire( cout ) << "rtn2, i:" << i << " c:" << c << endl;
		i = 2; c = 'c';									// change x, y
	}
};


struct Any{
	void operator()() {
		osacquire( cout ) << "[2] Second raise handled here by resume-any handler" << endl;
	}
}; // Any


_DualEvent D {};

class R {
    uBaseTask &p;
  public:
    R( uBaseTask &p ) : p( p ) {}
    void operator()( D &first ) {
		osacquire( cout ) << "first" << endl;
		_Resume _At p;
    }
};

void second( D &first ) {
    osacquire( cout ) << "second" << endl;
}

_Task T1 {
    uBaseTask &partner;

    void main() {
		osacquire( cout ) << "T1::main enter" << endl;
		{
			try <D, second> {
				R r( uThisTask() );
				try <D, r> {
					_Resume D() _At uThisTask();
					_Enable;
				}
				_Enable;
			}
		}
		osacquire( cout ) << "T1::main middle" << endl;
		{
			R r( partner );
			try <D, r> {
				_Enable;
			}
		}
		osacquire( cout ) << "T1::main exit" << endl;
	}
  public:
    T1( uBaseTask &partner ) : partner( partner ) {}
};

_Task T2 {
    uBaseTask &partner;

    void main() {
		osacquire( cout ) << "T2::main enter" << endl;
		{
			try {
				try {
					_Throw D() _At uThisTask();
					_Enable;
				} catch( D ) {
					osacquire( cout ) << "first" << endl;
					_Throw _At uThisTask();
					_Enable;
				}
			} catch( D ) {
				osacquire( cout ) << "second" << endl;
			}
		}
		osacquire( cout ) << "T2::main middle" << endl;
		{
			try {
				_Enable;
			} catch( D ) {
				osacquire( cout ) << "first" << endl;
				_Throw _At partner;
			}
		}
		osacquire( cout ) << "T2::main exit" << endl;
    }
  public:
    T2( uBaseTask &partner ) : partner( partner ) {}
};


void uMain::main() {
	int x = 0;
	char y = 'a';
	try <R1,rtn1> {
		Rtn2 rtn2( x, y );								// closure for locals

		g( x, y );
		osacquire( cout ) << "try<R1,rtn1> x:" << x << " y:" << y << endl;

		// Check multiple handlers, only one is used.
		try <R1><R2,rtn2> {
			f( x, y );
			osacquire( cout ) << "try<R2,rtn2>, x:" << x << " y:" << y << endl;
		} // try
		try <R1><R2,rtn2> {								// R1 empty handler
			g( x, y );
			osacquire( cout ) << "try<R1>, x:" << x << " y:" << y << endl;
		} // try
	} // try

    osacquire( cout ) << "=============" << endl;

	Any any;
	try <..., any> {									// test resume-any
		try <...> {
			_Resume R1( x, y );
			osacquire( cout ) << "[1] First raise is ignored and returns to here" << endl;
		}
		_Resume R3();
		osacquire( cout ) << "[3] Second raise returns to here" << endl;
	} // try

    osacquire( cout ) << "=============" << endl;
    {													// test nonlocal reraise
		T1 t( uThisTask() );
		try <D, second> {
			_Enable {
				_Resume D() _At t;
				yield();								// let t run
			}
		}
    }
    osacquire( cout ) << "=============" << endl;
    {													// test nonlocal rethrow
		T2 t( uThisTask() );
		try {
			_Enable {
				_Throw D() _At t;
				yield();								// let t run
			}
		} catch( D ) {
			osacquire( cout ) << "second" << endl;
		}
	}
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// End: //
