//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uIos.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:54:28 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Aug  6 14:16:58 2004
// Update Count     : 21
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uIos.h>


//######################### uIosWrapper ########################


uIosWrapper::uIosWrapper( uIos &stream ) : stream( stream ) {
    stream.uEnter();
} // uIosWrapper::uIosWrapper

uIosWrapper::~uIosWrapper() {
    stream.uLeave();
} // uIosWrapper::~uIosWrapper


//######################### uIos ########################


// free routines for ios

uIos &setbase( uIos &os, int b ) {
    uIosWrapper wrapper( os );

    os.iofile->setf( b ==  8 ? std::ios_base::oct :
		     b == 10 ? std::ios_base::dec :
		     b == 16 ? std::ios_base::hex :
		     std::ios_base::fmtflags(0), std::ios_base::basefield );
    return os;
} // setbase

uIos &setfill( uIos &os, int f ) {
    uIosWrapper wrapper( os );

    os.iofile->fill( f );
    return os;
} // setfill

uIos &setprecision( uIos &os, int p ) {
    uIosWrapper wrapper( os );

    os.iofile->precision( p );
    return os;
} // setprecision

uIos &setw( uIos &os, int w ) {
    uIosWrapper wrapper( os );

    os.iofile->width( w );
    return os;
} // setw

uIos &setiosflags( uIos &os, std::ios_base::fmtflags f ) {
    uIosWrapper wrapper( os );

    os.iofile->setf( f );
    return os;
} // setiosflags

uIos &resetiosflags( uIos &os, std::ios_base::fmtflags f ) {
    uIosWrapper wrapper( os );

    os.iofile->setf( std::ios_base::fmtflags(0), f );
    return os;
} // resetiosflags


void uIos::uEnter() {
    ownerlock.acquire();
} // uIos::uEnter

void uIos::uLeave() {
    ownerlock.release();
} // uIos::uLeave


uIos::uIos() {
} // uIos::uIos


// ios_base routines not requiring mutual exclusion

std::ios_base::fmtflags uIos::flags() const {
    return iofile->flags();
} // uIos::flags

std::streamsize uIos::precision() const {
    return iofile->precision();
} // uIos::precision

std::streamsize uIos::width() const {
    return iofile->width();
} // uIos::width

std::locale uIos::getloc() const {
    return iofile->getloc();
} // uIos::getloc


// ios_base routines requiring mutual exclusion

std::ios_base::fmtflags uIos::flags( std::ios_base::fmtflags fmtfl ) {
    uIosWrapper wrapper( *this );

    return iofile->flags( fmtfl );
} // uIos::flags

std::ios_base::fmtflags uIos::setf( std::ios_base::fmtflags fmtfl ) {
    uIosWrapper wrapper( *this );

    return iofile->setf( fmtfl );
} // uIos::setf

std::ios_base::fmtflags uIos::setf( std::ios_base::fmtflags fmtfl, std::ios_base::fmtflags mask ) {
    uIosWrapper wrapper( *this );

    return iofile->setf( fmtfl, mask );
} // uIos::setf

void uIos::unsetf( std::ios_base::fmtflags mask ) {
    uIosWrapper wrapper( *this );

    iofile->unsetf( mask );
} // uIos::unsetf

std::streamsize uIos::precision( std::streamsize prec ) {
    uIosWrapper wrapper( *this );

    return iofile->precision( prec );
} // uIos::precision

std::streamsize uIos::width( std::streamsize wide ) {
    uIosWrapper wrapper( *this );

    return iofile->width( wide );
} // uIos::width

std::locale uIos::imbue( const std::locale &loc ) {
    uIosWrapper wrapper( *this );

    return iofile->imbue( loc );
} // uIos::imbue

long &uIos::iword( int index ) {
    uIosWrapper wrapper( *this );

    return iofile->iword( index );
} // uIos::iword

void *&uIos::pword( int index ) {
    uIosWrapper wrapper( *this );

    return iofile->pword( index );
} // uIos::pword


// ios routines not requiring mutual exclusion

uIos::operator void*() const {
    return iofile;
} // uIos::operator *

bool uIos::operator!() const {
    return !iofile;
} // uIos::operator !

std::ios_base::iostate uIos::rdstate() const {
    return iofile->rdstate();
} // uIos::rdstate

//uIos uIos::tie() const {
//    return iofile->tie();
//} // uIos::bad

bool uIos::good() const {
    return iofile->good();
} // uIos::good

bool uIos::eof() const {
    return iofile->eof();
} // uIos::eof

bool uIos::fail() const {
    return iofile->fail();
} // uIos::fail

bool uIos::bad() const {
    return iofile->bad();
} // uIos::bad

std::ios_base::iostate uIos::exceptions() const {
    return iofile->exceptions();
} // uIos::exceptions

std::streambuf::char_type uIos::fill() const {
    return iofile->fill();
} // uIos::file

uFilebuf *uIos::rdbuf() const {
    return (uFilebuf *)iofile->rdbuf();
} // uIos::rebuf

char uIos::narrow( std::streambuf::char_type c, char dfault ) const {
    return iofile->narrow( c, dfault );
} // uIOs::narrow

std::streambuf::char_type uIos::widen( char c ) const {
    return iofile->widen( c );
} // uIos::widen



// ios routines requiring mutual exclusion

void uIos::clear( std::ios_base::iostate state ) {
    uIosWrapper wrapper( *this );

    iofile->clear( state );
    return;
} // uIos::clear

void uIos::setstate( std::ios_base::iostate state ) {
    uIosWrapper wrapper( *this );

    iofile->setstate( state );
    return;
} // uIos::setstate

void uIos::exceptions( std::ios_base::iostate except ) {
    uIosWrapper wrapper( *this );

    return iofile->exceptions( except );
} // uIos::exceptions

//uIos *uIos::tie( uIos *tiestr ) {
//    uIosWrapper wrapper( *this );
//
//    return iofile->tie( tiestr );
//} // uIos::tie

uFilebuf *uIos::rdbuf( uFilebuf *sb ) {
    uAbort( "uIos::rdbuf : not implemented" );
} // uIos::rdbuf

uIos &uIos::copyfmt( const uIos &rhs ) {
    uIosWrapper wrapper( *this );

    iofile->copyfmt( *iofile );
    return *this;
} // uIos::copyfmt

std::streambuf::char_type uIos::fill( std::streambuf::char_type ch ) {
    uIosWrapper wrapper( *this );

    return iofile->fill( ch );
} // uIos::fill


// additional concurrent routines

uBaseTask *uIos::owner() {
    uIosWrapper wrapper( *this );

    return ownerlock.owner();
} // uIos::owner


// Local Variables: //
// compile-command: "gmake install" //
// End: //
