//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uFStream.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 16:37:41 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul 15 16:42:47 2003
// Update Count     : 19
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
#include <uFStream.h>


//######################### uIFStream #########################


uIFStream::uIFStream() : uIStream( new uFilebuf( std::ios_base::in )  ) {
    deletebuf = 1;
} // uIFStream::uIFStream

uIFStream::uIFStream( const char *name, std::ios_base::openmode mode ) : uIStream( new uFilebuf( mode ) ) {
    deletebuf = 1;
    rdbuf()->open( name, mode );
} // uIFStream::uIFStream

bool uIFStream::is_open() {
    return rdbuf()->is_open();
} // uIFStream::is_open

void uIFStream::open( const char *name, std::ios_base::openmode mode ) {
    uIosWrapper wrapper( *this );

    rdbuf()->open( name, mode );
} // uIFStream::uIFStream

void uIFStream::close() {
    uIosWrapper wrapper( *this );

    rdbuf()->close();
} // uIFStream::close

uFilebuf *uIFStream::rdbuf() const {
    return (uFilebuf *)uIStream::rdbuf();
} // uIFStream::rdbuf


//######################### uOFStream #########################


uOFStream::uOFStream() : uOStream( new uFilebuf( std::ios_base::out ) ) {
    deletebuf = 1;
} // uOFStream::uOFStream

uOFStream::uOFStream( const char *name, std::ios_base::openmode mode ) : uOStream( new uFilebuf( mode ) ) {
    deletebuf = 1;
    rdbuf()->open( name, mode );
} // uOFStream::uOFStream

void uOFStream::open( const char *name, std::ios_base::openmode mode ) {
    uIosWrapper wrapper( *this );

    rdbuf()->open( name, mode );
} // uOFStream::uOFStream

void uOFStream::close() {
    uIosWrapper wrapper( *this );

    rdbuf()->close();
} // uOFStream::close

uFilebuf *uOFStream::rdbuf() {
    return (uFilebuf *)uOStream::rdbuf();
} // uOFStream::rdbuf


// Local Variables: //
// compile-command: "gmake install" //
// End: //
