//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1998
// 
// uSystemTask.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Mon Jun 22 15:23:25 1998
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Mar 13 17:43:48 2004
// Update Count     : 14
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_SYSTEMTASK_H__
#define __U_SYSTEMTASK_H__


uTask uSystemTask {
    friend uTask uMain;					// access: pthreadDetach, pthreadCheck
    friend uTask uPThread;				// access: pthreadDetachStart, pthreadDetachEnd

    uBaseTask *victim;					// communication

    // pthread

    static volatile bool pthreadDetach;			// optimization: prevent uMain calling pthreadCheck if no detached pthreads
    unsigned int pthreadDetachCnt;
    uCondition detached;

    uMutex void pthreadCheck();
    uMutex void pthreadDetachStart();
    uMutex void pthreadDetachEnd( uBaseTask &victim );

    void main();
  public:
    uSystemTask();
    ~uSystemTask();
    void reaper( uBaseTask &victim );
}; // uSystemTask


#endif // __U_SYSTEMTASK_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
