 #                               -*- Mode: Asm -*- 
 # 
 # uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1995
 # 
 # uSwitch-alpha.s -- 
 # 
 # Author           : Peter A. Buhr
 # Created On       : Sun Jan 15 10:52:17 1995
 # Last Modified By : Peter A. Buhr
 # Last Modified On : Mon Jul 21 21:17:26 2003
 # Update Count     : 23
 #
 # This  library is free  software; you  can redistribute  it and/or  modify it
 # under the terms of the GNU Lesser General Public License as published by the
 # Free Software  Foundation; either  version 2.1 of  the License, or  (at your
 # option) any later version.
 # 
 # This library is distributed in the  hope that it will be useful, but WITHOUT
 # ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
 # FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 # for more details.
 # 
 # You should  have received a  copy of the  GNU Lesser General  Public License
 # along  with this library.
 # 

 # This context switch routine depends on the fact that the stack of a new
 # thread has been set up to look like the thread has saved its context in
 # the normal manner.
 #
 # void uSwitch( uMachContext *to, uMachContext *from )

	.set noreorder
	.set volatile
	.set noat
	.file	1 "uSwitch-alpha.s"
.text
	.align	3
	.globl	uSwitch
	.ent	uSwitch
uSwitch:

	# Save volatile registers s0(r9)-s5(r14),fp(r15),ra(r26) on the stack.

	lda $sp,-64($sp)
	stq $9,0($sp)
	stq $10,8($sp)
	stq $11,16($sp)
	stq $12,24($sp)
	stq $13,32($sp)
	stq $14,40($sp)
	stq $fp,48($sp)
	stq $26,56($sp)

	# Save stack pointer in the "from" area at offset 0.

	stq $sp,0($17)

	# Load stack pointer from the "to" area at offset 0.

	ldq $sp,0($16)

	# Load volatile registers s0(r9)-s5(r14),fp(r15),ra(r26) on the stack.

	ldq $26,56($sp)
	ldq $fp,48($sp)
	ldq $14,40($sp)
	ldq $13,32($sp)
	ldq $12,24($sp)
	ldq $11,16($sp)
	ldq $10,8($sp)
	ldq $9,0($sp)
	lda $sp,64($sp)

	# Load the procedure address for global addressability from new context
	# offset 8, only significant when a new thread starts.

	ldq $27,8($16)

	# As well, the "to" parameter in $16 magically becomes the "This"
	# argument for uMachContext::uInvoke. Only significant when a new
	# thread starts.

	# Return to thread.

	ret $31,($26),1
	.end uSwitch

 ## Local Variables: ##
 ## compile-command: "gmake install" ##
 ## End: ##
