//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1997
// 
// uDefault.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Thu Mar 20 18:12:31 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Sep  1 23:27:23 2003
// Update Count     : 11
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_DEFAULT_H__
#define __U_DEFAULT_H__


// Define the default extension heap amount in units of bytes. When the uC++
// supplied heap reaches the brk address, the brk address is extended by the
// extension amount.

#define __U_DEFAULT_HEAP_EXPANSION__ (64 * 1024)


// Define the default scheduling pre-emption time in milliseconds.  A
// scheduling pre-emption is attempted every default pre-emption milliseconds.
// A pre-emption does not occur if the executing task is not in user code or
// the task is currently in a critical section.  A critical section begins when
// a task acquires a lock and ends when a user releases a lock.

#define __U_DEFAULT_PREEMPTION__ 100


// Define the default spin time in units of checks and context switches. The
// idle task checks the ready queue and context switches this many times before
// the UNIX process executing the idle task goes to sleep.

#define __U_DEFAULT_SPIN__ 500


// Define the default stack size in bytes.  Change the implicit default stack
// size for a task or coroutine created on a particular cluster.

#define __U_DEFAULT_STACK_SIZE__ 30000


extern unsigned int uDefaultHeapExpansion();		// default heap expansion size (bytes)
extern unsigned int uDefaultStackSize();		// default cluster coroutine/task stack size (bytes)
extern unsigned int uMainStackSize();			// default uMain task stack size (bytes)
extern unsigned int uDefaultSpin();			// default processor spin time for idle task (context switches)
extern unsigned int uDefaultPreemption();		// default processor scheduling pre-emption durations (milliseconds)


#endif // __U_DEFAULT_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
