//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Philipp E. Lim 1996
// 
// Sleep.cc -- 
// 
// Author           : Philipp E. Lim
// Created On       : Wed Jan 10 17:02:39 1996
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jan 29 08:35:57 2004
// Update Count     : 16
// 

#include <uC++.h>
#include <uIOStream.h>

uClock Clock;
volatile int x = 0, y = 1;

uTask fred {
    void main() {
	uTime start, end;
	for ( ;; ) {
	  if ( x == 20 ) break;
	    if ( x < y ) x += 1;
	    start = Clock.uGetTime();
	    uTimeout( uDuration( 1 ) );
	    end = Clock.uGetTime();
	    uCout << uAcquire << "fred slept for " << end - start << " seconds" << endl << uRelease;
	} // for
	uCout << uAcquire << "fred finished" << endl << uRelease;
    } // fred::main
}; // fred

uTask mary {
    void main() {
	uTime start, end;
	for ( ;; ) {
	  if ( y == 20 ) break;
	    if ( y == x ) y += 1;
	    start = Clock.uGetTime();
	    uTimeout( uDuration( 2 ) );
	    end = Clock.uGetTime();
	    uCout << uAcquire << "mary slept for " << end - start << " seconds" << endl << uRelease;
	} // for
	uCout << uAcquire << "mary finished" << endl << uRelease;
    } // mary::main
}; // mary

void uMain::main() {
    fred f;
    mary m;
} // uMain::main

// Local Variables: //
// compile-command: "u++ Sleep.cc" //
// End: //
