//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// ClientUNIX.cc -- Client for UNIX/stream socket test. Client reads from
// standard input, writes the data to the server, reads the data from the
// server, and writes that data to standard output.
// 
// Author           : Peter A. Buhr
// Created On       : Tue Jan  7 08:42:32 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul 22 08:41:52 2003
// Update Count     : 88
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uSocket.h>

#define EOD '\377'
// minimum buffer size is 2, 1 character and string terminator, '\0'
#define BufferSize (65)

int rcnt = 0, wcnt = 0;

uTask reader {
	uSocketClient &client;

	void main() {
		char buf[BufferSize];
		int len;

		for ( ;; ) {
			len = client.read( buf, sizeof(buf) );
			// uCerr << uAcquire << "Client::reader read len:" << len << endl << uRelease;
		  if ( buf[0] == EOD ) break;
			// The EOD character can be piggy-backed onto the end of the message.
		  if ( buf[len - 1] == EOD ) { rcnt += len - 1; uCout.write( buf, len - 1 ); break; }
			rcnt += len;
			uCout.write( buf, len );
		} // for
		// connection not closed until after this data received
		buf[0] = '\0';
		client.write( buf, sizeof(char) );
	} // reader::main
  public:
	reader( uSocketClient &client ) : client ( client ) {
	} // reader::reader
}; // reader

uTask writer {
	uSocketClient &client;

	void main() {
		char buf[BufferSize];

		for ( ;; ) {
			uCin.get( buf, sizeof(buf), '\0' );	// leave room for string terminator
			int len = strlen( buf );
			// uCerr << uAcquire << "Client::writer read len:" << len << endl << uRelease;
		  if ( buf[0] == '\0' ) break;
			wcnt += len;
			client.write( buf, len );
		} // for
		buf[0] = EOD;
		client.write( buf, sizeof(char) );
	} // writer::main
  public:
	writer( uSocketClient &client ) : client( client ) {
	} // writer::writer
}; // writer

void uMain::main() {
	switch ( argc ) {
	  case 2:
		break;
	  default:
		uCerr << "Usage: " << argv[0] << " socket-name" << endl;
		uExit( -1 );
	} // switch

	uSocketClient client( argv[1] );					// connection to server
	{
		reader rd( client );							// emit worker to read from server and write to output
		writer wr( client );							// emit worker to read from input and write to server
	}
	if ( wcnt != rcnt ) {
		uAbort( "not all data transfered\n" );
	} // if
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++-work -o Client ClientUNIX.cc" //
// End: //
