//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 2003
// 
// EHM9.cc -- recursive resumption
// 
// Author           : Peter A. Buhr
// Created On       : Sun Dec  7 12:15:30 2003
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 19 16:40:41 2004
// Update Count     : 25
// 

#include <uC++.h>
#include <uIOStream.h>


uRaiseEvent R1 {};
uInitEvent(R1);
uRaiseEvent R2 {};
uInitEvent(R2);


void H1( R2 ) {
	uCerr << uAcquire << "enter H1" << endl << uRelease;
	uCerr << uAcquire << "exit  H1" << endl << uRelease;
} // H1

void H2( R1 ) {
	uCerr << uAcquire << "enter H2" << endl << uRelease;
	uRaise R2();
	uCerr << uAcquire << "exit  H2" << endl << uRelease;
} // H2

void H3( R2 ) {
	uCerr << uAcquire << "enter H3" << endl << uRelease;
	uRaise R1();
	uCerr << uAcquire << "exit  H3" << endl << uRelease;
} // H3


// Checks marking of handlers is performed correctly during propagation.
// Marking prevents recursive resumption.

void uMain::main () {
	try <R2, H1> {
		try <R1, H2> {
			try <R2, H3> {
				uCerr << uAcquire << "before raise" << endl << uRelease;
				uRaise R1();
				uCerr << uAcquire << "after raise" << endl << uRelease;
			} // try
		} // try
	} // try
	uCerr << uAcquire << "finished" << endl << uRelease;
} // uMain::main


// Local Variables: //
// tab-width: 4 //
// End: //
