//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1997
// 
// EHM1.cc -- testing exception handling mechanism
// 
// Author           : Peter A. Buhr
// Created On       : Wed Nov 26 23:06:25 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 26 08:42:48 2004
// Update Count     : 210
// 


#include <uC++.h>
#include <uIOStream.h>


//######################### uBaseCoroutine::uFailure #########################


uThrowEvent xxx {
  public:
    xxx( const char *const msg ) : uEHM::uThrowClass( msg ) {}
};
uInitEvent(xxx);


uCoroutine CoroutineDummy1 {
    void main() {
	uThrow xxx( "test" );
    } // CoroutineDummy1::main
  public:
    void mem() { uResume; }
}; // CoroutineDummy1


//######################### uCondition::uWaitingFailure #########################


uTask TaskDummy1 {
    uCondition x;
  public:
    void mem() {
	uWait x;
    } // TaskDummy1::mem
  private:
    void main() {
	uAccept( mem );
    } // TaskDummy1::main
}; // TaskDummy1

uTask TaskDummy2 {
    TaskDummy1 &t1;

    void main() {
#if 0
	t1.mem();
#endif
	try {
	    t1.mem();
	} catch( uCondition::uWaitingFailure &evt ) {
	    uCout << uAcquire << "handled event uCondition::uWaitingFailure : task " << &(evt.source()) << " (" << evt.source().uGetName() << ") found blocked task" << " " << &uThisTask() << " (" << uThisTask().uGetName() << ") on condition variable " << evt.uConditionID() << endl << endl << uRelease;
	} // try
    } // TaskDummy2::main
  public:
    TaskDummy2( TaskDummy1 &t1 ) : t1( t1 ) {}
}; // TaskDummy2


//######################### uSerial::uRendezvousFailure #########################


uTask TaskDummy3 {
    uBaseTask &t;
  public:
    TaskDummy3( uBaseTask &t ) : t( t ) {}
    void mem() {
    } // TaskDummy3::mem
  private:
    void main() {
	uThrow xxx( "test" ) uAt t;
#if 0
	uAccept( mem );
#endif
	try {
	    uAccept( mem );
	} catch ( uSerial::uRendezvousFailure &evt ) {
	    uCout << uAcquire << "handled event uSerial::uRendezvousFailure : accepted call fails from task " << &(evt.source()) << " (" << evt.sourceName() << ") to mutex member of task " << &uThisTask() << " (" << uThisTask().uGetName() << ")" << endl << endl << uRelease;
	} // try
    } // TaskDummy3::main
}; // TaskDummy3


//######################### uSerial::uEntryFailure (acceptor/signalled stack) #########################


uTask TaskDummy4 {
    uCondition temp;
  public:
    void mem() {
	uWait temp;
    } // TaskDummy4::mem
  private:
    void main() {
	uAccept( mem );					// let TaskDummy5 in so it can wait
	uSignal temp;					// put TaskDummy5 on A/S stack
	uAccept( ~TaskDummy4 );				// uMain is calling the destructor
    } // TaskDummy4::main
}; // TaskDummy4

uTask TaskDummy5 {
    TaskDummy4 &t4;
  public:
    TaskDummy5( TaskDummy4 &t4 ) : t4( t4 ) {}
  private:
    void main() {
#if 0
	t4.mem();
#endif
	try {
	    t4.mem();
	} catch( uSerial::uEntryFailure &evt ) {
	    uCout << uAcquire << "handled event uSerial::uEntryFailure : while executing mutex destructor, task " << &(evt.source()) << " (" << evt.source().uGetName() << ") found task " << &uThisTask() << " (" << uThisTask().uGetName() << ") " << evt.message() << endl << endl << uRelease;
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    } // TaskDummy5::main
}; // TaskDummy5


//######################### uSerial::uEntryFailure (entry queue) #########################


uTask TaskDummy6 {
  public:
    void mem() {
    } // TaskDummy6::mem
  private:
    void main() {
	uAccept( ~TaskDummy6 );
    } // TaskDummy6::main
};

uTask TaskDummy7 {
    TaskDummy6 &t6;
  public:
    TaskDummy7( TaskDummy6 &t6 ) : t6( t6 ) {}
  private:
    void main() {
#if 0
	t6.mem();
#endif
	try {
	    t6.mem();
	} catch( uSerial::uEntryFailure &evt ) {
	    uCout << uAcquire << "handled event uSerial::uEntryFailure : while executing mutex destructor, task " << &(evt.source()) << " (" << evt.source().uGetName() << ") found task " << &uThisTask() << " (" << uThisTask().uGetName() << ") " << evt.message() << endl << endl << uRelease;
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    } // TaskDummy7::main
}; // TaskDummy7


void uMain::main() {
    //######################### uBaseCoroutine::uFailure #########################
    {
	CoroutineDummy1 dummy1;
#if 0
	dummy1.mem();					// first call fails
#endif
	try {
	    dummy1.mem();				// first call fails
	} catch( uBaseCoroutine::uFailure &evt ) {
	    uCout << uAcquire << "handled event uBaseCoroutine::uFailure : " << evt.message() << " coroutine " << &uThisCoroutine() << " (" << uThisCoroutine().uGetName() << ") from coroutine " << &(evt.source()) << " (" << evt.sourceName() << ")" << endl << endl << uRelease;
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    }
    //######################### uCondition::uWaitingFailure #########################

    TaskDummy1 *t1 = new TaskDummy1;
    TaskDummy2 *t2 = new TaskDummy2( *t1 );
    delete t1;						// delete t1 with t2 blocked on condition variable
    delete t2;

    //######################### uSerial::uRendezvousFailure #########################
    {
	TaskDummy3 t3( uThisTask() );
	try {
	    uEnable {
		t3.mem();
	    } // uEnable
	} catch( xxx &evt ) {
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    }
    //######################### uSerial::uEntryFailure (acceptor/signalled stack) #########################

    TaskDummy4 *t4 = new TaskDummy4;
    TaskDummy5 *t5 = new TaskDummy5( *t4 );
    delete t4;
    delete t5;

    //######################### uSerial::uEntryFailure (entry queue) #########################

    TaskDummy6 *t6 = new TaskDummy6;
    TaskDummy7 *t7 = new TaskDummy7( *t6 );
    delete t6;
    delete t7;

    uCerr << "successful execution" << endl;
} // uMain::main
