//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// DatingNew.cc -- Exchanging Values Between Tasks
// 
// Author           : Peter A. Buhr
// Created On       : Thu Aug  2 11:45:46 1990
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jan 28 23:20:16 2004
// Update Count     : 70
// 

#include <uC++.h>
#include <uIOStream.h>
#include <uIOManip.h>


uMonitor DatingService {
	int GirlPhoneNo, BoyPhoneNo;
  public:
	DatingService() {
		GirlPhoneNo = BoyPhoneNo = -1;
	}; // DatingService::DatingService
	int Girl( int PhoneNo );
	int Boy( int PhoneNo );
}; // DatingService

int DatingService::Girl( int PhoneNo ) {
	GirlPhoneNo = PhoneNo;
	if ( BoyPhoneNo == -1 ) uAccept( Boy );
	int temp = BoyPhoneNo;
	BoyPhoneNo = -1;
	return temp;
} // DatingService::Girl

int DatingService::Boy( int PhoneNo ) {
	BoyPhoneNo = PhoneNo;
	if ( GirlPhoneNo == -1 ) uAccept( Girl );
	int temp = GirlPhoneNo;
	GirlPhoneNo = -1;
	return temp;
} // DatingService::Boy

uTask Girl {
	DatingService &TheExchange;

	void main() {
		uYield( rand() % 100 );							// don't all start at the same time
		int PhoneNo = rand() % 10000000;
		int partner = TheExchange.Girl( PhoneNo );
		uCout << uAcquire << "Girl:" << setw(8) << &uThisTask() << " at " << setw(8) << PhoneNo
			<< " is dating Boy  at " << setw(8) << partner << endl << uRelease;
	} // main
  public:
	Girl( DatingService &TheExchange ) : TheExchange( TheExchange ) {
	} // Girl
}; // Girl

uTask Boy {
	DatingService &TheExchange;

	void main() {
		uYield( rand() % 100 );							// don't all start at the same time
		int PhoneNo = rand() % 10000000;
		int partner = TheExchange.Boy( PhoneNo );
		uCout << uAcquire << " Boy:" << setw(8) << &uThisTask() << " at " << setw(8) << PhoneNo
			<< " is dating Girl at " << setw(8) << partner << endl << uRelease;
	} // main
  public:
	Boy( DatingService &TheExchange ) : TheExchange( TheExchange ) {
	} // Boy
}; // Boy


void uMain::main() {
	const int NoOfGirls = 20;
	const int NoOfBoys = 20;

	DatingService TheExchange;
	Girl *girls;
	Boy  *boys;

	girls = new Girl[NoOfGirls]( TheExchange );
	boys  = new Boy[NoOfBoys]( TheExchange );

	delete [] girls;
	delete [] boys;

	uCout << uAcquire << "successful execution" << endl << uRelease;
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ DatingNew.cc" //
// End: //
