#include "UniversalBooleanTest.hh"
#include "tyvis/UniversalBoolean.hh"
#include <warped/SerializedInstance.h>
#include <clutils/StringUtilities.h>

bool
UniversalBooleanTest::getDefaultValue(){
  static int defaultValue = true;
  return defaultValue;
}

void 
UniversalBooleanTest::setUp(){
  toTest = new UniversalBoolean( getDefaultValue() );
}

void 
UniversalBooleanTest::tearDown(){
  delete toTest;
}

void
UniversalBooleanTest::testGetUniversalKind(){
  CPPUNIT_ASSERT( toTest->getUniversalKind() == VHDLData::UNIVERSAL_BOOLEAN );
}

void
UniversalBooleanTest::testGetLength(){
  CPPUNIT_ASSERT( toTest->length() == 1 );
}

void
UniversalBooleanTest::testPrint(){
  ostringstream printStream;
  toTest->print( printStream );
  CPPUNIT_ASSERT( "TRUE" == printStream.str() );
}

void
UniversalBooleanTest::testEqual(){
  UniversalBoolean a( true );
  UniversalBoolean b( true );
  
  CPPUNIT_ASSERT( a == b );
}

void
UniversalBooleanTest::testNotEqual(){
  UniversalBoolean a( true );
  UniversalBoolean b( false );
  
  CPPUNIT_ASSERT( a != b );
}

void
UniversalBooleanTest::testGreater(){
  UniversalBoolean a( false );
  UniversalBoolean b( true );
  
  CPPUNIT_ASSERT( b > a );
}

void
UniversalBooleanTest::testGreaterEqual(){
  UniversalBoolean a( false );
  UniversalBoolean b( true );
  UniversalBoolean c( true );
  
  CPPUNIT_ASSERT( b >= a );
  CPPUNIT_ASSERT( b >= c );
}

void
UniversalBooleanTest::testLess(){
  UniversalBoolean a( false );
  UniversalBoolean b( true );
  
  CPPUNIT_ASSERT( a < b );
}

void
UniversalBooleanTest::testLessEqual(){
  UniversalBoolean a( false );
  UniversalBoolean b( true );
  UniversalBoolean c( true );
  
  CPPUNIT_ASSERT( a <= c );
  CPPUNIT_ASSERT( b <= c );
}

void
UniversalBooleanTest::testClone(){
  UniversalBoolean *cloned = dynamic_cast<UniversalBoolean *>(toTest->clone());
  CPPUNIT_ASSERT( cloned != 0 );
  CPPUNIT_ASSERT( cloned != toTest );
  CPPUNIT_ASSERT( *cloned = *toTest );
  delete cloned;
}

void
UniversalBooleanTest::testSerialization(){
  SerializedInstance *serialized = static_cast<Serializable *>(toTest)->serialize();
  CPPUNIT_ASSERT( serialized->getDataType() == toTest->getDataType() );
  UniversalBoolean *deserialized = dynamic_cast<UniversalBoolean *>( serialized->deserialize() );
  CPPUNIT_ASSERT( deserialized != 0 );
  CPPUNIT_ASSERT( deserialized != toTest );
  CPPUNIT_ASSERT( *deserialized = *toTest );
  delete deserialized;
}
