#include "_savant_entity_elab.hh"
#include <iostream>
#include "SignalNetinfo.hh"
#include "SourceData.hh"
#include "SourceInfo.hh"
#include "ScalarType.hh"
#include "RecordType.hh"
#include "ArrayType.hh"
#include "PortAssociation.hh"
#include "TypeConvert.hh"
#include "SourceTypeConvert.hh"

int _savant_entity_elab::resolutionFnIdCounter = 0;
int _savant_entity_elab::typeConversionFnIdCounter = 0;

ResolutionFnPtr *savantResolutionFn;
TypeConversionFnPtr *savantTypeConversionFn;

_savant_entity_elab::_savant_entity_elab(){}

_savant_entity_elab::~_savant_entity_elab() {
  int noOfDrivers, index;
  for ( noOfDrivers = 0 ; noOfDrivers < driverData.getNumberOfElements(); noOfDrivers++){
    delete static_cast<VHDLType *>(driverData.getElement(noOfDrivers));
  }
  for ( index = 0; index < typeConvertData.getNumberOfElements(); index++){
    delete static_cast<TypeConvert *>(typeConvertData.getElement(index));
  }
  for ( index = 0; index < blockForDrivers.getNumberOfElements(); index++){
    delete static_cast<Block *>(blockForDrivers.getElement(index));
  }
  if ( savantTypeConversionFn != NULL ){
    delete [] savantTypeConversionFn;
    savantTypeConversionFn = NULL;
  }
}

void
_savant_entity_elab::instantiate( Hierarchy * ){
  cerr << "Dynamic Instantiation called for an unbounded component/entity/configuration" << endl;
}

void 
_savant_entity_elab::createNetInfo() {
  cerr << "Dynamic Elaboration called for an unbounded component/entity/configuration" << endl;
}

void 
_savant_entity_elab::connect(int inputSignals, int outputSignals, ...){
  int noOfSignals = inputSignals + outputSignals;
  va_list ap;
  va_start(ap, outputSignals);
  for( int i=0; i < noOfSignals; i++ ){
    addToFanOut( va_arg(ap, VHDLType*) );
  }
  va_end(ap);
}


void
_savant_entity_elab::Add(VHDLType &val, VHDLType &rhs) {
  val.Add( rhs );
}

void
_savant_entity_elab::Add(VHDLType &val, SignalNetinfo &sig) {
  val.Add( sig );
}

void
_savant_entity_elab::Add(VHDLType &val, VHDLKernel *processPtr) {
  ASSERT( processPtr != 0 );
  val.Add( processPtr );
}

void
_savant_entity_elab::Add(VHDLType &val, VHDLKernel *processPtr, int sigId) {
  val.Add( processPtr, sigId );
}


void
_savant_entity_elab::Add(VHDLType &val, SignalNetinfo *ptr) {
  val.Add( ptr );
}

int
_savant_entity_elab::addResolutionFn(ResolutionFnPtr resolve) {
  ResolutionFnPtr *tempPtr = new ResolutionFnPtr[resolutionFnIdCounter + 1];
  int i;
  int resolutionFnId =0;
  int found = 0;
  for(i = 0; i < resolutionFnIdCounter; i++) {
    if(savantResolutionFn[i] == resolve) {
      resolutionFnId = i;
      found = 1;
    }
    tempPtr[i] = savantResolutionFn[i];
  }
  if(found == 0) {
    tempPtr[resolutionFnIdCounter] = resolve;
    if(savantResolutionFn != NULL) {
      delete [] savantResolutionFn;
    }
    savantResolutionFn = tempPtr;
    resolutionFnIdCounter++;
  } else {
    delete [] tempPtr;
  }
  return resolutionFnId;
}

int
_savant_entity_elab::addTypeConversionFn(TypeConversionFnPtr upConvert) {
  TypeConversionFnPtr *tempPtr = new TypeConversionFnPtr[typeConversionFnIdCounter + 1];
  int i;
  int typeConversionFnId =0;
  int found = 0;
  for(i = 0; i < typeConversionFnIdCounter; i++) {
    if(savantTypeConversionFn[i] == upConvert) {
      typeConversionFnId = i;
      found = 1;
    }
    tempPtr[i] = savantTypeConversionFn[i];
  }
  if(found == 0) {
    tempPtr[typeConversionFnIdCounter] = upConvert;
    typeConversionFnId = typeConversionFnIdCounter;
    if(savantTypeConversionFn != NULL) {
      delete [] savantTypeConversionFn;
    }
    savantTypeConversionFn = tempPtr;
    typeConversionFnIdCounter++;
  } else {
    delete [] tempPtr;
  }
  return typeConversionFnId;
}


void
_savant_entity_elab::setResolutionFunctionId(VHDLType &sigInfo,
					     ResolutionFnPtr resolve) {
  int resolutionFnId = addResolutionFn(resolve);
  //Set the resolution Function Id foa all the elements of the VHDLType
  //If the VHDLType is a composite type the, previously set functionId,
  //will be overwritten, if there is any. This is valid as per
  //Resoultion Functions section of the LRM
  sigInfo.setResolutionFunctionId(resolutionFnId);
}

void
_savant_entity_elab::setUpConversionFunctionId(VHDLType &sigInfo,
					       TypeConversionFnPtr upConvert){
  int typeConversionFnId = addTypeConversionFn(upConvert);
  
  //Set the type conversion Function Id to all the elements of the VHDLType
  sigInfo.setTypeConversionFunctionId(typeConversionFnId);
}
  
void 
_savant_entity_elab::setDownConversionFunctionId(ScalarType &sigInfo, 
						 TypeConversionFnPtr downConvert){
  ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
  SourceBase *source = ((SignalNetinfo *) sigInfo.getObject())->getSource();
  if(source == NULL) {
    source = new SourceInfo;
  }
  savantTypeConversionFn[typeConversionFnIdCounter] = downConvert;
  source->setDownTypeConversionFnId(typeConversionFnIdCounter++);
}
  
void 
_savant_entity_elab::addChild( SignalNetinfo *targetSigInfo, 
			       VHDLType *sourceSignal, 
			       VHDLKernel *sourceProcess ){
  ASSERT(targetSigInfo->getKind() == ObjectBase::SIGNAL_NETINFO);

  if(targetSigInfo->getSource() == NULL) {
    targetSigInfo->setSource( new SourceData );
    targetSigInfo->getSource()->addChild(sourceSignal, sourceProcess);
  } 
  else {
    switch(targetSigInfo->getSource()->getNumChildren()) {
    case 0:{
      SourceBase *temp = targetSigInfo->getSource();
      switch(temp->get_kind()) {
      case SourceBase::SOURCE_DATA:
	if (sourceProcess == SourceBase::ANONYMOUS_PROCESS_ID) {
	  cerr << "Warning !! _savant_entity_elab::addChild() called with"
	       << "ANONYMOUS_PROCESS_ID but this is not the first guy to be"
	       << " added" << endl;
	  return;
	  // Anonymous drivers need to be recorded only if it is the first guy.
	  // If an real driver already exists then ignore all these guys.
	}
	else {
	  if (temp->_is_anonymous_driver() == true) {
	    sourceSignal = targetSigInfo->getSource()->getData();
	    targetSigInfo->setSource( new SourceData );
	    targetSigInfo->getSource()->addChild(sourceSignal, sourceProcess);
	  }
	  else {
	    targetSigInfo->setSource( new SourceInfo );
	    targetSigInfo->getSource()->addChild(temp->getData(), temp->getSourceId());
	    targetSigInfo->getSource()->addChild(sourceSignal, sourceProcess);
	  }
	}
	delete temp;
	break;
	
      case SourceBase::SOURCE_INFO:
	targetSigInfo->getSource()->addChild(sourceSignal, sourceProcess);
	break;
      case SourceBase::SOURCE_BASE:
	cerr << "An object of SourceBase instantiated! I dunno how!!" << endl;
	abort();
	break;
      case SourceBase::SOURCE_TYPE_CONVERT:
	targetSigInfo->getSource()->addChild(temp);
	targetSigInfo->getSource()->addChild(sourceSignal, sourceProcess);
      }	// switch(temp->get_kind())
      break;
    }
    default:
      if (sourceProcess != SourceBase::ANONYMOUS_PROCESS_ID) {
	// Check if there is an anonymous driver already present in the tree
	// is so then delete that guy and add the new guy.
	if (targetSigInfo->getSource()->getNumChildren() == 1) {
	  // Check if the first guy is an anonymous driver. If so pitch him
	  // after copying the default initial value.
	  ASSERT ( targetSigInfo->getSource()->get_kind() == SourceBase::SOURCE_INFO );
	  SourceInfo *tempSourceInfo = (SourceInfo *) targetSigInfo->getSource();
	  if (tempSourceInfo->getChild(0)->_is_anonymous_driver() == true) {
	    ASSERT (tempSourceInfo->getChild(0)->get_kind() == 
		    SourceBase::SOURCE_DATA);
	    VHDLType *tempData = tempSourceInfo->getChild(0)->getData();
	    // tempSourceInfo->child = NULL;
	    delete tempSourceInfo;
	    targetSigInfo->setSource( new SourceInfo );
	    targetSigInfo->getSource()->addChild(tempData, sourceProcess);
	  }
	  else {
	    targetSigInfo->getSource()->addChild(sourceSignal, sourceProcess);
	  }
	}
	else {
	  targetSigInfo->getSource()->addChild(sourceSignal, sourceProcess);	  
	}
      }
      break;
    } // switch
  } // else
}  

void 
_savant_entity_elab::addChild( VHDLType &targetSigInfo, 
			       VHDLType &sourceSignal, 
			       VHDLKernel *sourceProcess ){
  static int addOrNot = 0;
  // add the driver data in the block called driverData and delete it in
  // destructor. So the VHDLType *data is not deleted in the
  // SourceSignalData node.

  if ( addOrNot == 0 ){
    driverData.addElement( &sourceSignal );
  }
  addOrNot++;
  
  switch(targetSigInfo.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    if( !targetSigInfo.is_driver_already_set() || targetSigInfo.is_resolved_signal() ){
      addChild( dynamic_cast<SignalNetinfo*>(targetSigInfo.getObject()), 
		&sourceSignal,
		sourceProcess);
      if ( sourceProcess != SourceBase::ANONYMOUS_PROCESS_ID){
	dynamic_cast<SignalNetinfo*>(targetSigInfo.getObject())->set_driver_added_flag();
      }
    }
    break;
  case ARRAY_TYPE:
    if ( !targetSigInfo.is_driver_already_set() || targetSigInfo.is_resolved_signal() ){
      int elementCount  = sourceSignal.length(0);
      for( int i = 0; i < elementCount; i++) {
	addChild( static_cast<ArrayType &>(targetSigInfo).get_element(i),
		  static_cast<ArrayType &>(sourceSignal).get_element(i), 
		  sourceProcess);
      }
    }
    break;
  case RECORD_TYPE:
    if ( !targetSigInfo.is_driver_already_set() || targetSigInfo.is_resolved_signal() ){
      for( int i = 1; i <= static_cast<RecordType&>(targetSigInfo).get_number_of_fields(); i++) {
	addChild( static_cast<RecordType &>(targetSigInfo).get_field(i),
		  static_cast<RecordType &>(sourceSignal).get_field(i), 
		  sourceProcess );
      }
    }
    break;
  default:
    cerr<< "Wrong Type passed\n";
    break;
  }

  //subtract 1 from addOrNot so when it is zero alone, we add it to the
  // data structure DriversData which will be deleted in the destructor.
  addOrNot--;
}

void 
_savant_entity_elab::addChild(VHDLType &targetSigInfo, VHDLType &sourceSigInfo) {
  switch(targetSigInfo.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    addChild( static_cast<SignalNetinfo*>(targetSigInfo.getObject()),
	      static_cast<SignalNetinfo*>(sourceSigInfo.getObject()) );
    static_cast<SignalNetinfo*>(sourceSigInfo.getObject())->set_sourcebase_delete_flag(false);
    break;
  case ARRAY_TYPE: {
    int elementCount  = dynamic_cast<ArrayType &>(targetSigInfo).length(0);
    for( int i = 0; i < elementCount; i++) {
      addChild( dynamic_cast<ArrayType &>(targetSigInfo).get_element(i),
		dynamic_cast<ArrayType &>(sourceSigInfo).get_element(i) );
    }
    break;
  }
  case RECORD_TYPE:
    for( int i = 1; 
	 i <= static_cast<RecordType &>(targetSigInfo).get_number_of_fields();
	 i++) {
      addChild( static_cast<RecordType &>(targetSigInfo).get_field(i),
		static_cast<RecordType &>(sourceSigInfo).get_field(i) );
    }
    break;
  default:
    cerr<< "Wrong Type passed " << endl;
    break;
  }
}

void 
_savant_entity_elab::addChild( SignalNetinfo *parentSigInfo, SignalNetinfo *childDriverInfo ){
  ASSERT( parentSigInfo->getKind() == ObjectBase::SIGNAL_NETINFO );
  ASSERT( childDriverInfo->getKind() == ObjectBase::SIGNAL_NETINFO );
  // If the childDriverInfo does not have any driver for this signal, we have
  // nothing to do here.
  if( childDriverInfo->getSource() == NULL ){
    return;			// SK
  }
  if( parentSigInfo->getSource() == NULL ){
    // this coud be just parentSigInfo->source = childDriverInfo->source, but why this way
    parentSigInfo->setSource( new SourceInfo );
    parentSigInfo->getSource()->addChild(childDriverInfo->getSource());
  } 
  else if( parentSigInfo->getSource()->get_kind() == SourceBase::SOURCE_DATA || 
	   parentSigInfo->getSource()->get_kind() == SourceBase::SOURCE_TYPE_CONVERT ){
    if ( parentSigInfo->getSource()->get_kind() == SourceBase::SOURCE_TYPE_CONVERT){
      SourceBase *temp_src = parentSigInfo->getSource();
      parentSigInfo->setSource( new SourceInfo );
      parentSigInfo->getSource()->addChild(temp_src);
      parentSigInfo->getSource()->addChild(childDriverInfo->getSource());
    } 
    else {
      if ( parentSigInfo->getSource()->_is_anonymous_driver() == false ){
	SourceBase *temp_src = parentSigInfo->getSource();
	parentSigInfo->setSource( new SourceInfo );
	parentSigInfo->getSource()->addChild(temp_src);
	parentSigInfo->getSource()->addChild(childDriverInfo->getSource());
      } 
      else {
	parentSigInfo->setSource( new SourceInfo );
	parentSigInfo->getSource()->addChild(childDriverInfo->getSource());
      }
    }
  } 
  else {
    parentSigInfo->getSource()->addChild(childDriverInfo->getSource());
  }    
}  

// Move the source pointer to point to the root of the source tree.  This
// required since the resolution has to start from the root of the source
// tree.
void 
_savant_entity_elab::setSourceToRoot(ScalarType &sigInfo) {
  ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
  SourceBase *sigsrc = ((SignalNetinfo *) sigInfo.getObject())->getSource();
  while(sigsrc->getParent() != NULL) {
    sigsrc = sigsrc->getParent();
  }
  ((SignalNetinfo *) sigInfo.getObject())->setSource( sigsrc );
}


void
_savant_entity_elab::setSourceInfo(VHDLType &val, VHDLType &rhs) {
  //Assumes val and rhs are of same types
  int i;
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    if ( (((SignalNetinfo *) val.getObject())->getSource() != NULL) &&
	 (((SignalNetinfo *) val.getObject())->get_sourcebase_delete_flag()
	  == true)) {
      // delete ((SignalNetinfo *) val.getObject())->source;
    }
    ((SignalNetinfo*)val.getObject())->setSource( ((SignalNetinfo*)rhs.getObject())->getSource() );
    ((SignalNetinfo*)val.getObject())->set_sourcebase_delete_flag(false);
    ((SignalNetinfo*)val.getObject())->addAdditionalDriver(((SignalNetinfo*)rhs.getObject())->getAdditionalDriverList());
    break;
  case ARRAY_TYPE: {
    ArrayType &target = (ArrayType &) val;
    ArrayType &source = (ArrayType &) rhs;
    int elementCount  = val.length(0);

    for(i = 0; (i < elementCount); i++) {
      setSourceInfo(target.get_element(i), source.get_element(i));
    }
    break;
  }
  case RECORD_TYPE:
    for(i=1; i <= (*(RecordType*)&val).get_number_of_fields(); i++) {
      setSourceInfo((*(RecordType*)&val).get_field(i), (*(RecordType*)&rhs).get_field(i));
    }
    break;
  default:
    cerr<< "Wrong Type passed " << endl;
    break;
  }
}

Block *
_savant_entity_elab::getDownTypeConversionFnList(VHDLType &signal){
  switch (signal.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ASSERT( signal.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO );
    return &(static_cast<SignalNetinfo *>(signal.getObject()))->getDownTypeConversionFnList();
    break;

  case ARRAY_TYPE:
    return getDownTypeConversionFnList(signal.get_element(0));
    break;
    
  case RECORD_TYPE:
    return getDownTypeConversionFnList(((RecordType &) signal).get_field(1));
    break;

  default:
    cerr << "Error : _savant_entity_elb::getDownTypeConversionFnList() - "
	 << "unknown type passed." << endl;
  }

  return NULL; // Keep compiler from wailing
}

void
_savant_entity_elab::addDownTypeConversionFn(VHDLType &lhs, VHDLType &rhs, TypeConversionFnPtr typeConversionFn) {
  
  Block *rhsDownTypeConversionFnList;
  int   *newFnId;
  int i;
  ASSERT( lhs.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO );
  ASSERT( rhs.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO );

 
  rhsDownTypeConversionFnList = getDownTypeConversionFnList(rhs);

  switch (lhs.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    for(i = 0; (i < rhsDownTypeConversionFnList->getNumberOfElements()); i++) {
      ASSERT( lhs.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO );
      dynamic_cast<SignalNetinfo *>(lhs.getObject())->addDownTypeConversionFn(rhsDownTypeConversionFnList->getElement(i));
    }
    
    newFnId = new int;
    *newFnId = addTypeConversionFn(typeConversionFn);
    
    dynamic_cast<SignalNetinfo *>(lhs.getObject())->addDownTypeConversionFn(newFnId);
    
    break;
  
  case ARRAY_TYPE: {
    ArrayType target( dynamic_cast<ArrayType &>(lhs) );
    for(i = 0; (i < target.get_number_of_elements(0)); i++) {
      addDownTypeConversionFn(lhs.get_element(i), rhs, typeConversionFn);
    }
    break;
  }
  case RECORD_TYPE:
    for(i = 1; (i <= lhs.get_number_of_elements(0)); i++) {
      addDownTypeConversionFn(((RecordType &) lhs).get_field(i), rhs, typeConversionFn);
    }
    break;

  default:
    cerr << "Error : _savant_entity_elab::addDownTypeConversionFn() - "
	 << "unknown vhdl type." << endl;
  }
}

void 
_savant_entity_elab::buildSignalTree() {
  Block *portList = &portMapAspect.portAssociationList;
  for( int i = 0;
       i < portMapAspect.portAssociationList.getNumberOfElements();
       i++ ){
    PortAssociation *portElement = (PortAssociation*)portList->getElement(i);
    Add( *portElement->getFormal(), *portElement->getActual() );

    switch(portElement->getMode()) {
    case OUT:
    case INOUT:
      addChild( *portElement->getFormal(),
		*portElement->getActual() );
      break;
    case IN:
      break;
    default:
      cerr << "Port declarations of mode IBUFFFER and LINKAGE" << endl
	   << "Not Yet Supported" << endl;
      break;
    }
  }
}

void
_savant_entity_elab::collectFanout( SignalNetinfo *sigNetInfo, const VHDLType &val ){
  int i;
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    sigNetInfo->Add((SignalNetinfo*)(*(ScalarType*)&val).getObject());
    break;
  case ARRAY_TYPE: {
    ArrayType &source = (ArrayType &) val;
    int elementCount  = source.length(0);
    
    for(i = 0; (i < elementCount); i++) {
      collectFanout(sigNetInfo, source.get_element(i));
    }
    break;
  }
  case RECORD_TYPE:
    for(i=1; i <= (*(RecordType*)&val).get_number_of_fields() ; i++) {
      collectFanout(sigNetInfo,(*(RecordType*)&val).get_field(i));
    }
    break;
  default:
    cerr<< "Wrong Type passed\n";
    break;
  }
}

void
_savant_entity_elab::Addall( VHDLType &dest, const VHDLType &src ){
  SignalNetinfo tmp;
  collectFanout(&tmp, src);
  Add(dest, &tmp);
}

void
_savant_entity_elab::addUpConvertDriver(VHDLType &sigInfo, VHDLType &data, TypeConvert *typeConvertPtr){
  
  int index;
  static int AddorNot = 0;

  if ( AddorNot == 0 ){
    typeConvertData.addElement(typeConvertPtr);
  }
  AddorNot++;
  
  switch (sigInfo.get_kind()){
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
    addUpConvertDriver((SignalNetinfo *)sigInfo.getObject(), &data, typeConvertPtr);
    break;
  case ARRAY_TYPE: {
    ArrayType &source = (ArrayType &) data;
    ArrayType &target = (ArrayType &) sigInfo;
    int elementCount  = target.length(0);
    
    for(index = 0; (index < elementCount); index++) {
      addUpConvertDriver(target.get_element(index), source.get_element(index), typeConvertPtr);
    }
    break;
  }
  case RECORD_TYPE:
    for(index=1; index <= ((RecordType *)&sigInfo)->get_number_of_fields(); index++){
      addUpConvertDriver(((RecordType*)&sigInfo)->get_field(index), ((RecordType *)&data)->get_field(index), typeConvertPtr);
    }
    break;
  default:
    cerr << "Wrong Type Passed\n";
    break;
  }
  AddorNot--;
}
 
void
_savant_entity_elab::addUpConvertDriver(SignalNetinfo *sigInfo, VHDLType *data, TypeConvert *typeConvertPtr){
  SourceTypeConvert *tmp_stc = NULL;
  
  ASSERT(sigInfo->getKind() == ObjectBase::SIGNAL_NETINFO);
  tmp_stc = new SourceTypeConvert ;
  tmp_stc->setData(data);
  tmp_stc->setTypeConvert(typeConvertPtr);
  if ( sigInfo->getSource() == NULL ){
    sigInfo->setSource( tmp_stc );
  } else {
    sigInfo->getSource()->addChild(tmp_stc);
  }
}

void
_savant_entity_elab::addDriver(VHDLType &sigInfo, VHDLType &driverInfo){

  Block *newDriverList = NULL;
  static int call_block_present = 0;
  int i;

  if ( call_block_present == 0){
    if ( _is_block_present(sigInfo) == false ) {
      newDriverList = new Block;
      blockForDrivers.addElement((void *)newDriverList);
      newDriverList->addElement(&driverInfo);
    }
  }

  call_block_present++;

  switch (sigInfo.get_kind()){
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
    if ( newDriverList != NULL ){
      ((SignalNetinfo *)sigInfo.getObject())->setAdditionalDriverList(newDriverList);
    } else {
      ((SignalNetinfo *)sigInfo.getObject())->addAdditionalDriver(&driverInfo);
    }
    break;
  case ARRAY_TYPE: {
    ArrayType &target = (ArrayType &) sigInfo;
    int elementCount  = target.length(0);

    if (newDriverList == NULL) {
      for(i = 0; (i < elementCount); i++) {
	addDriver(target.get_element(i), driverInfo);
      }
    } else {
      for(i = 0; (i < elementCount); i++) {
	addDriver(target.get_element(i), newDriverList);
      }
    }
    break;
  }
  case RECORD_TYPE:
    if ( newDriverList == NULL ){
      for ( i = 1 ; i <= ((RecordType *)&sigInfo)->get_number_of_elements(); i++){
	addDriver(((RecordType *)&sigInfo)->get_field(i), driverInfo);
      }
    } else {
      for ( i = 1 ; i <= ((RecordType *)&sigInfo)->get_number_of_elements(); i++){
	addDriver(((RecordType *)&sigInfo)->get_field(i), newDriverList);
      }
    }
    break;
  default:
    cerr << "_savant_entity_elab::addDriver  Wrong Type Passed" << endl;
    break;
  }

  call_block_present--;
}

void
_savant_entity_elab::addDriver(VHDLType &sigInfo, Block *newDriverList){
  int i;
  
  switch (sigInfo.get_kind()){
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
    ((SignalNetinfo *)sigInfo.getObject())->setAdditionalDriverList(newDriverList);
    break;
  case ARRAY_TYPE: {
    ArrayType &target = (ArrayType &) sigInfo;
    int elementCount  = target.length(0);
    for (i = 0; (i < elementCount); i++) {
      addDriver(target.get_element(i), newDriverList);
    }
    break;
  }
  case RECORD_TYPE:
    for (i = 1; i <= ((RecordType *)&sigInfo)->get_number_of_elements(); i++){
      addDriver(((RecordType *)&sigInfo)->get_field(i), newDriverList);
    }
    break;
  default:
    cerr << "_savant_entity_elab::addDriver wrong type passed "<< endl;
    break;
  }
}

bool
_savant_entity_elab::_is_block_present(VHDLType &sigInfo){
  int i ;

  switch (sigInfo.get_kind()){
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ASSERT(sigInfo.getObject()->getKind() == ObjectBase::SIGNAL_NETINFO);
    if ( ((SignalNetinfo *)sigInfo.getObject())->getAdditionalDriverList() == NULL ){
      return false;
    } else {
      return true;
    }
    break;
  case ARRAY_TYPE: {
    ArrayType &source = (ArrayType &) sigInfo;
    int elementCount  = source.length(0);

    for(i = 0; (i < elementCount); i++) {
      if (_is_block_present(source.get_element(i)) == false)  {
	return false;
      }
    }

    return true;
  }
  case RECORD_TYPE:
    for ( i = 1 ; i <= ((RecordType *)&sigInfo)->get_number_of_elements(); i++){
      if ( _is_block_present(((RecordType *)&sigInfo)->get_field(i)) == false ){
	return false ;
      }
    }
    return true;

  default:
    cerr << "_savant_entity_elab::_is_block_present  Wrong Type Passed" << endl;
    // Just to keep compiler from giving warnings.
    return true;
    break;
  }
}

void
_savant_entity_elab::addDriverData(VHDLType *data){
  driverData.addElement((void*)data);
}

int
_savant_entity_elab::checkSetSourceInfo( VHDLType &dest, 
					 int srcStart, 
					 vector<VHDLType *> &src ){
  ASSERT ( dest.get_number_of_elements() > 0 );
  ASSERT ( src[srcStart]->get_number_of_elements() > 0 );
  
  if (dest.get_number_of_elements(0) == src[srcStart]->get_number_of_elements()) {
    setSourceInfo(dest, (VHDLType &) (*src[srcStart]));
    
    return (srcStart + 1);
  }

  if (dest.get_number_of_elements() > src[srcStart]->get_number_of_elements()) {
    VHDLType *newType   = dest.clone();
    int elements_copied_so_far = 0;

    while (elements_copied_so_far < dest.get_number_of_elements()) {
      newType->get_element(elements_copied_so_far) = *(src[srcStart]);
      elements_copied_so_far += src[srcStart]->get_number_of_elements();
      srcStart++;
    }

    setSourceInfo(dest, *newType);
    delete newType;
  }
  else {
    cerr << "Error : Unhandled case in checkSetSourceInfo()\n";
  }
  
  return srcStart;
}

int
_savant_entity_elab::checkAdd( VHDLType &dest,
			       int srcStart,
			       vector<VHDLType *> &src ){
  ASSERT ( dest.get_number_of_elements() > 0 );
  ASSERT ( src[srcStart]->get_number_of_elements() > 0 );
  
  if (dest.get_number_of_elements() == src[srcStart]->get_number_of_elements()) {
    Add(dest, (VHDLType &) (*src[srcStart]));

    return (srcStart + 1);
  }
  
  if (dest.get_number_of_elements() > src[srcStart]->get_number_of_elements()) {
    VHDLType *newType   = dest.clone();
    int elements_copied_so_far = 0;
    
    while (elements_copied_so_far < dest.get_number_of_elements()) {
      newType->get_element(elements_copied_so_far) = *(src[srcStart]);
      elements_copied_so_far += src[srcStart]->get_number_of_elements();
      srcStart++;
    }
    
    Add(dest, (VHDLType &) *newType);
    delete newType;
  }
  else {
    cerr << "Error : Unhandled case in checkSetSourceInfo()\n";
  }

  return srcStart;
}

void
_savant_entity_elab::addToFanOut( VHDLType *newFanOut ){
  fanOutInfo.push_back( newFanOut );
}
