//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef PHYSICALTYPE_HH
#define PHYSICALTYPE_HH

#include "tyvis/TypeInfo.hh"
#include "tyvis/ScalarType.hh"

class IntegerType;
class UniversalLongLongInteger;

extern PhysicalTypeInfo SavanttimeType_info;

class PhysicalType: public ScalarType {
public:
  PhysicalType() : ScalarType() {}
  PhysicalType(const PhysicalType&);
  
  PhysicalType(ObjectBase::ObjectType, const TypeInfo & = SavanttimeType_info);
  PhysicalType(ObjectBase::ObjectType, 
	       const UniversalLongLongInteger&, const TypeInfo& = SavanttimeType_info);
  PhysicalType(ObjectBase::ObjectType, const PhysicalType&, const TypeInfo& = SavanttimeType_info);
  PhysicalType(bool, const PhysicalType&, const TypeInfo& = SavanttimeType_info);
  PhysicalType(const PhysicalType&, const TypeInfo&);
  
  virtual ~PhysicalType() {}
  
  PhysicalType& operator = (const PhysicalType&);
  
  Type get_kind() const;
  virtual const VHDLData& leftValue();
  
  static PhysicalType LEFT (const TypeInfo &);
  static PhysicalType RIGHT(const TypeInfo &);
  static PhysicalType HIGH (const TypeInfo &);
  static PhysicalType LOW  (const TypeInfo &);
  static EnumerationType ASCENDING (const TypeInfo &);
  static PhysicalType      SUCC      (const PhysicalType&);
  static PhysicalType      PRED      (const IntegerType&);
  static PhysicalType      LEFTOF    (const PhysicalType&);
  static PhysicalType      RIGHTOF   (const PhysicalType&);
  static ArrayType         IMAGE     (const PhysicalType&);
  static PhysicalType      VAL       (const PhysicalType&, const TypeInfo &);
  static PhysicalType      VAL       (const IntegerType&, const TypeInfo &);
  static IntegerType       POS       (const PhysicalType&, const TypeInfo &);

  const VHDLVTime getVTime() const;

  TypeInfo& getTypeInfo() const;

  PhysicalType vhdlPlus( const RValue & ) const;
  PhysicalType vhdlMinus( const RValue & ) const;
  PhysicalType vhdlMultiply( const RValue & ) const;
  PhysicalType vhdlDivide( const RValue & ) const;
  IntegerType  vhdlDivide( const PhysicalType & ) const;
  PhysicalType vhdlAbs() const;
  PhysicalType vhdlUnaryPlus() const;
  PhysicalType vhdlUnaryMinus() const; 
   
public:
  PhysicalTypeInfo range;
};

#endif
