
//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef INTEGERTYPE_HH
#define INTEGERTYPE_HH

#include "tyvis/ScalarType.hh"
#include "tyvis/TypeInfo.hh"
#include "tyvis/ArrayType.hh"

extern IntegerTypeInfo SavantintegerType_info;

class IntegerType: public ScalarType {
public:
  IntegerType() : ScalarType() {}

  IntegerType(const IntegerType&);
  IntegerType(ObjectBase::ObjectType, int);
  
  //The new constructors to hold the attribute information also
  IntegerType(ObjectBase::ObjectType, const TypeInfo& = SavantintegerType_info);
  IntegerType(ObjectBase::ObjectType, const UniversalInteger&, 
	      const TypeInfo& = SavantintegerType_info);
  IntegerType(ObjectBase::ObjectType, const IntegerType&, 
	      const TypeInfo& = SavantintegerType_info);
  IntegerType(bool, const IntegerType&, const TypeInfo& = SavantintegerType_info);
  IntegerType(const IntegerType&, const TypeInfo&);
  
  virtual ~IntegerType() {}

  IntegerType& operator = (const IntegerType&);

  Type get_kind() const;
  virtual const VHDLData& leftValue();

  //Code added for folding
  //All the attributes of IntegerTypeRange
  static IntegerType LEFT (const TypeInfo &);
  static IntegerType RIGHT(const TypeInfo &);
  static IntegerType HIGH (const TypeInfo &);
  static IntegerType LOW  (const TypeInfo &);

  static EnumerationType   ASCENDING (const TypeInfo &);
  static IntegerType       SUCC      (const IntegerType&);
  static IntegerType       PRED      (const IntegerType&);
  static IntegerType       LEFTOF    (const IntegerType&);
  static IntegerType       RIGHTOF   (const IntegerType&);
  static ArrayType         IMAGE     (const IntegerType&);
  static IntegerType       VALUE     (const ArrayType&, 
				      const TypeInfo& = SavantintegerType_info);
  static IntegerType       POS       (const IntegerType&, 
				      const TypeInfo& = SavantintegerType_info);
  static IntegerType       VAL       (const IntegerType&, 
				      const TypeInfo& = SavantintegerType_info);
  
  TypeInfo& getTypeInfo() const;
  
  IntegerTypeInfo range;

  IntegerType vhdlPlus( const RValue & ) const;
  IntegerType vhdlMinus( const RValue & ) const;
  IntegerType vhdlUnaryPlus() const;
  IntegerType vhdlUnaryMinus() const;
  IntegerType vhdlMultiply( const RValue & ) const;
  PhysicalType vhdlMultiply( const PhysicalType & ) const;
  IntegerType vhdlDivide( const RValue & ) const;
  IntegerType vhdlMod( const RValue & ) const;
  IntegerType vhdlRem( const RValue & ) const;
  IntegerType vhdlPow( const RValue & ) const;
  IntegerType vhdlAbs() const;

  static IntegerType INVALID_TYPE_OBJECT;
};


#endif

