#ifndef ACCESSTYPE_HH
#define ACCESSTYPE_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------
#include "tyvis/VHDLType.hh"
#include "tyvis/Block.hh"
class VHDLKernel;

class AccessType : public VHDLType {
public:
  // Required for alias initialization

  AccessType(bool, const AccessType &);
  AccessType() : VHDLType(false) { val = NULL; }
  AccessType(const AccessType &);
  AccessType(VHDLType &);
  AccessType(const VHDLType &);
  AccessType(VHDLType *);
  
  void setPointer(VHDLType *src);
  
  VHDLType&  all();

  void addValueToListForDeletion();

  virtual VHDLType* getPointer() const;
  virtual void resetPointer();

  Type get_kind() const;
  void print(ostream& = cout) const;

  virtual ObjectBase* getObject() const;
  virtual ObjectBase::ObjectType getKind() const;

  VHDLType* clone() const;
  VHDLType& operator=(const VHDLType& val);
  AccessType& operator=(const AccessType& val);
  
  VHDLType& operator=(VHDLType *);
  VHDLType& operator[](const ScalarType &val) const;
  VHDLType& operator[](const int) const;
  
  bool operator==(const RValue &) const;
  bool operator!=(const RValue &) const;
  bool operator>(const RValue &) const;
  bool operator>=(const RValue &) const;
  bool operator<(const RValue &) const;
  bool operator<=(const RValue &) const;

  virtual void deallocate();
  static Block accessedObjectList;

  VHDLType *val;
};

extern int savantdeallocate( VHDLKernel *, AccessType & );

extern ostream& operator<<(ostream&, const AccessType &);

#endif
