/*
 * dp.h - tuXeyes figure definition for dustpuppy
 * Copyright (C) 1999 Ivo van der Wijk
 *
 * Copyright (c) 1999 Ivo van der Wijk
 * 
 * The tux image is (c) Larry Ewing (lewing@isc.tamu.edu)
 * The dustpuppy image is (c) Illiad (http://www.userfriendly.org)
 * The bsd daemon ("Chuck") is (c) Eric Green
 * The luxus image is (c) Urs M. E. Streidl (http://www.gigaperls.org/linux/)
 * 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Please note: Pixmaps/images are copyrighted by Illiad. Check 
 * http://www.userfriendly.org/ for more dustpuppies and fun cartoons!
 */
#ifndef DP_H
#define DP_H

#include <qapplication.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qimage.h>

#include "figure.h"

/*
 * Include pixmaps. Masks will be converted to bitmaps
 */
#include "dustpuppy/dp_main.xpm"
#include "dustpuppy/dp_mask.xpm"
#include "dustpuppy/dp_leftpupil.xpm"
#include "dustpuppy/dp_rightpupil.xpm"
#include "dustpuppy/dp_eyes.xpm"
#include "dustpuppy/dp_eyemask.xpm"

class	dp: public figure
{
public:
	dp(): figure()
	{
		loadImage(tuxOrig, dp_main);
		loadImage(tuxMaskXPM, dp_mask);
		loadImage(leftPupilOrig, dp_leftpupil);
		loadImage(rightPupilOrig, dp_rightpupil);
		loadImage(eyeRegionOrig, dp_eyes);
		loadImage(eyeMaskXPM, dp_eyemask);

		// these values have to determined by examining the picture
		leftEyeX = 51;
		leftEyeY = 86;
		rightEyeX = 66;
		rightEyeY = 83;
		leftPupilRadius = 7;
		rightPupilRadius = 7;
		eyeXOffset = 23;
		eyeYOffset = 51;
	}
	~dp() {}
private:
};

#endif // DP_H
