<?php
/*
 * Copyright 2002 by Gero Kohnert
 *
 *   CVS Info:  $Id: group_overview.php,v 1.17 2004/02/17 10:39:10 schueler Exp $
 *   $Author: schueler $
 *
 * Group of Interest Management
 *
 * @modulegroup group
 * @module group_overview
 * @package group
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'permission.p3';
 include_once 'webelements.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("group","overview");
 loadmodule("group");
 loadlayout();

 /**
  * display an overview of CRM groups
  */
 class group_overview extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $tutos,$lang;

     $result = $this->dbconn->Exec($this->q);
     $n = $result->numrows();
     if ( $this->format == "xml" ) {
       $c = new group($this->dbconn);
       echo $c->exportXMLHeader();
       echo $c->exportXML_Head();
       echo "<group_set>\n";
       $a = 0;
       while ($a < $n) {
         $c->read_result($result,$a);
         $c->read_member();
         $a++;
         if ( ! $c->see_ok() ) {
           continue;
         } else {
           echo $c->exportXML_start();
           echo $c->exportXML_body();
           echo $c->exportXML_end();
         }
       } 
       echo "</group_set>\n";
     } else {
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       $result->free();
       return;
     }
       echo $this->OverviewTableStart();
       echo "<thead>\n";
       echo "<tr>\n";
       echo $this->orderHeader("name",$lang['GroupName'],$this->link2);
       echo $this->orderHeader("",$lang['GroupDesc'],$this->link2);
       echo $this->orderHeader("",$lang['GroupMember'],$this->link2);
       echo "</tr>\n";
       echo "</thead>\n";
  
       if ( $this->start == -1 ) {
         $a = $n - $tutos[maxshow];
         $end = $n;
         $this->start = $a;
       } else {
         $a = $this->start;
         $end = $this->start + $tutos[maxshow];
       }
  
       echo "<tbody>\n";
       $line = 1;
       while ( ($a < $n) && ($a < $end) ) {
         $c = new group($this->dbconn);
         $c->read_result($result,$a);
         $c->read_member();
         $a++;
         if ( ! $c->see_ok() ) {
           continue;
         }
         echo $this->OverviewRowStart($line);
         echo "<td valign=\"top\">". $c->getLink() ."</td>";
         echo "<td valign=\"top\">". myentities($c->desc) ."&nbsp;</td>";
         echo "<td align=\"right\" valign=\"top\">". count($c->member) ."</td>";
         echo $this->OverviewRowEnd($line++);
       }
       echo "</tbody>\n";
  
       echo "<tfoot>\n";
       echo $this->list_navigation($this->link1,3,$this->start,$a,$n);
       echo "</tfoot>\n";
       echo $this->OverviewTableEnd();
     }
     $result->free();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang,$tutos;

     $this->name = $lang['GroupOverview'];

     if ( ! $this->user->feature_ok(usegroups,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     $this->link1 = "group/group_overview.php";
     $this->q = "SELECT * FROM ". $this->dbconn->prefix ."groups";
     $pre = " WHERE ";

     if ( isset($_GET['name']) && ($_GET['name'] != "*") && ($_GET['name'] != "") ) {
       $this->q .= $pre . $this->dbconn->Like("name",$_GET['name']);
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"name=". UrlEncode($_GET['name']));
     }

     check_dbacl($this->q, $this->user->id);

     # sorting
     $xxx = "";
     $this->link2 = $this->link1;
     order_parse($this->q,$this->link1,$xxx,$xxx,"name");

     if ( $this->user->feature_ok(usegroups,PERM_NEW) ) {
       $x = array( url => "group/group_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['GroupCreate'],
                   category => array("group","new","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new group_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
