<?php
/*
 * Checklist: Copyright 2002 by Markus Leist under GNU GPL
 * TUTOS:     Copyright 1999 - 2002 by Gero Kohnert
 *
 *  CVS Info:  $Id: checkfield_overview.php,v 1.20 2003/04/10 11:49:07 markusleist Exp $
 *  $Author: markusleist $
 *
 */
$tutos['base'] = "../..";
ini_set("include_path","..");
include_once 'webelements.p3';
include_once 'permission.p3';

include_once 'checklist/checklist.pinc';
include_once 'checklist/checkfield.pinc';

check_user();
loadmodule("checklist");
loadlayout();

/**
 * display a checklist page
 */
class checkfield_overview extends layout {
  /**
   *
   */
  Function info() {
    global $lang,$tutos;
    $ref_id=-1;
    $my_array = array();
    
    $result = $this->dbconn->Exec($this->q);
    $n = $result->numrows();
    if ( 0 == $n) {
      echo $this->error($lang['Err0048']);
      $result->free();
      return;
    }

    if ($this->format == "checklist") {
      echo "<form name=\"editchecklist\" action=\"checklist_ins.php\" method=\"POST\">\n";
      echo $this->OverviewTableStart();
      echo "<thead>\n";

      if ( $this->checklistID > 0 ) {
        $tmp_checklist = new checklist( $this->dbconn);
        $tmp_checklist->read( $this->checklistID);
        if ( $tmp_checklist->type == CL_TYPE_TEMPL ) {  // class
          echo "<tr>\n";
          echo " <th colspan=\"4\">".$lang['ChecklistOKClass']."</th>\n";
          echo "</tr>\n";
        }
        if ( $tmp_checklist->type == CL_TYPE_WORKING ) {  // instance
          echo "<tr>\n";
          echo " <th colspan=\"4\">".$lang['ChecklistOKInstance']."</th>\n";
          echo "</tr>\n";
        }
        unset( $tmp_checklist);
      }

      echo "<tr>\n";
      echo $this->orderHeader("name",$lang['CheckfieldName'],$this->link2);
      echo $this->orderHeader("f_val",$lang['CheckfieldValue'],$this->link2);
      echo "<th>".$lang['ChecklistDescription']."</th>";
      echo "</tr>\n";
      echo "</thead>\n";

      $a = 0;
      $end = $n;

      $line = 0;
      while ( ($a < $n) && ($a < $end) ) {
        $c = new checkfield($this->dbconn);
        $c->read_result($result,$a);
        $a++;
        if ( ! $c->see_ok() ) {
          continue;
        }
        $c->read_reference();
        $my_array[]=$c->id;
        $ref_id = $c->ref->id;

        echo $this->OverviewRowStart($line);
        echo "<td valign=\"top\">". $c->getLink() ."</td>";

        if ( $c->type == CF_TYPE_TEXT) {  //   Textfield
          echo " <td>".$c->getTextfield( "fld_".$c->id, $c->id);"</td>\n";
        } elseif ( $c->type == CF_TYPE_CHECKBOX) {  //   Checkbox
          echo " <td>".$c->getCheckbox( "fld_".$c->id, $c->id)."</td>\n";
        } elseif ( $c->type == CF_TYPE_BOOL) {  //   Yes/No
          echo " <td>".$c->getYesNo( "fld_".$c->id, $c->id)."</td>\n";
        } elseif ( $c->type == CF_TYPE_RANGE) {  //   Number-Range
          echo " <td>".$c->getNbrRange( "fld_".$c->id, $c->id)."</td>\n";
        } elseif ( $c->type == CF_TYPE_RATE) {  //   Rating-Range
          echo " <td>".$c->getRatingRange( "fld_".$c->id, $c->id)."</td>\n";
        } elseif ( $c->type == CF_TYPE_TRISTATE) {  //   Yes/No/not tested
          echo " <td>".$c->getTriState( "fld_".$c->id, $c->id)."</td>\n";
        } else {
          echo "<td valign=\"top\">d". $c->type ."</td>";
        }
        if ( $c->getHelp() ) {
          echo "<td valign=\"top\">". makelink( "javascript:void(0);", $c->getDesc(), "", $c->getHelp()) . "</td>";
        } else {
          echo "<td valign=\"top\">". $c->getDesc() . "</td>";
        }
        echo $this->OverviewRowEnd($line++);
      }

      if ( $ref_id != -1 ) {
        $this->addHidden("ref_id",$ref_id);
        $this->addHidden("nbr_end",$end);
        $this->addHidden("checklist_ins","from_editor");
      }
      echo "<tr>\n";
      submit_reset(0,-1,1,0,0,0);
      echo "</tr>\n";
      echo $this->OverviewTableEnd();
      hiddenFormElements();
      echo $this->getHidden();
      echo "</form>\n";
    } else {
      echo $this->OverviewTableStart();
      echo "<tr>\n";
      if ( ! isset ($_GET['xf']) ) {
        echo "<th NOWRAP>".$lang['CheckfieldPos']."</th>"; 
      }
      echo $this->orderHeader("name",$lang['CheckfieldName'],$this->link2);
      echo $this->orderHeader("f_type",$lang['CheckfieldType'],$this->link2);
      echo $this->orderHeader("f_val",$lang['CheckfieldValue'],$this->link2);
      echo $this->orderHeader("link_id",$lang['CheckfieldReference'],$this->link2);
      echo $this->orderHeader("creation",$lang['created'],$this->link2);
      echo $this->orderHeader("creator",$lang['CheckfieldCreator'],$this->link2);
      if ( $tutos[massupdate] == 1 ) {
        echo "  <TH NOWRAP><INPUT TYPE=checkbox name=checkit onClick=\"CheckAll2();\"></TH>\n";
      }
      echo "</tr>\n";

      if ( $this->start == -1 ) {
        $a = $n - $tutos[maxshow];
        $end = $n;
        $this->start = $a;
      } else {
        $a = $this->start;
        $end = $this->start + $tutos[maxshow];
      }

      $line = 0;
      while ( ($a < $n) && ($a < $end) ) {
        $c = new checkfield($this->dbconn);
        $c->read_result($result,$a);
        $c->read_reference();
        $a++;
        if ( ! $c->see_ok() ) {
          continue;
        }
        echo $this->OverviewRowStart($line);

        if ( ! isset ($_GET['xf']) ) {
          echo "<td valign=\"top\">". 
          makelink("checklist/checklist_ins.php?move=up&id=".$c->link_id."&fid=".$c->id ,$this->theme->getImage(up,'list'),sprintf($lang['CheckfieldPosUp'],"none2u")) .
          makelink("checklist/checklist_ins.php?move=down&id=".$c->link_id."&fid=".$c->id ,$this->theme->getImage(down,'list'),sprintf($lang['CheckfieldPosDown'],"none2d")) .
	"</td>";
        }
        echo "<td valign=\"top\">". $c->getLink() ."</td>";
        echo "<td valign=\"top\">". $c->getObjType() ."</td>";
        echo "<td valign=\"top\">". $c->getValue() ."</td>";
        echo "<td valign=\"top\">". $c->getRefLink() ."&nbsp;</td>";
        echo " <td>". $c->creation->getDateTime() ."</TD>\n";
        echo " <td>&nbsp;". $c->creator->getLink($c->creator->getShortname()) ."</td>\n";
        if ( $tutos[massupdate] == 1 ) {
          if ( $c->mod_ok() ) {
            echo " <td><input name=\"mark[]\" type=\"checkbox\" value=\"". $c->id ."\"></td>\n";
          } else {
            echo "<td>&nbsp;-&nbsp;</td>";
          }
        }
        echo $this->OverviewRowEnd($line++);
      }

      echo $this->list_navigation($this->link1,7+ $tutos[massupdate],$this->start,$a,$n);
      if ( $tutos[massupdate] == 1 ) {
        echo $this->UpdateRowStart(6);
        echo sprintf($lang['withmarked'],$lang['Checkfields']);
        echo "<select name=\"action\">\n";
        echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
        echo " <option value=\"-2\">". $lang['Delete'] ."</option>\n";
        foreach($lang['CheckfieldTypes'] as $i => $f) {
          echo " <option value=\"".$i."\">". $lang['CheckfieldType'] .":". $f ."</option>\n";
        }
        echo "</select>\n";
        echo $this->UpdateRowEnd(2);
      }
      echo $this->OverviewTableEnd();
    }
    $result->free();
  }
  /**
   * naviagte
   */
  Function navigate() {
    global $tutos,$lang;

    echo "<tr><td>";

    if ( $this->user->feature_ok(usechecklists,PERM_NEW) ) {
      echo menulink("checklist/checkfield_new.php",$lang['NewEntry'],$lang['CheckfieldCreate']) . "<br>\n";
      if ( $this->checklistID > 0 ) {
    echo menulink("checklist/checkfield_overview.php?link_id=".$this->checklistID,$lang['CheckfieldOverview'],$lang['CheckfieldOverview']) . "<br>\n";
    echo menulink("checklist/checkfield_overview.php?link_id=".$this->checklistID."&format=checklist" ,$lang['ChecklistEditor'],$lang['ChecklistEditor']) ."<br>\n";
    echo menulink("checklist/checklist_show.php?id=".$this->checklistID,$lang['ChecklistDetail'],$lang['ChecklistDetail']) ."<BR>\n";

    $tmp_checklist = new checklist( $this->dbconn);
    $tmp_checklist->read( $this->checklistID);
    if ( $tmp_checklist->class_id > 0 ) {
      echo menulink("checklist/checklist_show.php?id=".$tmp_checklist->class_id ,$lang['ChecklistDetailClass'],$lang['ChecklistDetailClass']) ."<br>\n";
    }
    unset( $tmp_checklist);
      }
    }
    echo "</td></tr>";
  }
  /**
   * prepare
   */
  Function prepare() {
    global $msg,$lang,$HTTP_GET_VARS;

    if ($this->format == "checklist") {
      $this->name = $lang['ChecklistEditor'];
    } else {
      $this->name = $lang['ChecklistDetail'];
    }
    $this->checklistID = -1;

    $this->link1 = "checklist/checkfield_overview.php";
    $this->q = "SELECT * FROM ". $this->dbconn->prefix ."checkfields WHERE (deleted=".$this->dbconn->notime() ." or deleted is null)";
    $pre = " AND ";

    if ( isset($HTTP_GET_VARS['name']) && ($HTTP_GET_VARS['name'] != "*") && ($HTTP_GET_VARS['name'] != "") ) {
      $this->q .= $pre . $this->dbconn->Like("name",$HTTP_GET_VARS['name']);
      $pre = " AND ";
      $this->link1 = addUrlParameter($this->link1,"name=". UrlEncode($HTTP_GET_VARS['name']));
    }
    if ( isset($HTTP_GET_VARS['link_id']) && ($HTTP_GET_VARS['link_id'] != "*") && ($HTTP_GET_VARS['link_id'] != "") ) {
      $this->checklistID = $HTTP_GET_VARS['link_id'];
      $this->q .= $pre . $this->dbconn->Like("cl_id",$HTTP_GET_VARS['link_id']);
      $pre = " AND ";
      $this->link1 = addUrlParameter($this->link1,"link_id=". UrlEncode($HTTP_GET_VARS['link_id']));
    }

    // check_dbacl( $this->q, $this->user->id);

    // sorting
    $xxx = "";
    $this->link2 = $this->link1;
    order_parse($this->q,$this->link1,$xxx,$xxx,"f_pos");
  }
}

$l = new checkfield_overview($current_user);
$l->display();
$dbconn->Close();
?>
