<?
/**
 * Here we publish XML RPC services
 *
 * The login mecanism is not yet operationnal, so you just give the
 * username to use as first argument to all methods.
 *
 * You have to install the free xml rpx lib from
 * http://scripts.incutio.com/xmlrpc/ in order for this to work.
 * Place the php file under the tutos/php/xmlrpc/lib subdirectory.
 *
 * $Id: services.php,v 1.1.2.2 2004/06/18 15:23:31 tapoueh Exp $
 */

$tutos['base'] = "../..";
ini_set("include_path", "..");

include_once 'base.pinc';
include_once 'readlang.p3';
include_once 'permission.p3';

include('lib/IXR_Library.inc.php');

class tutos_services extends IXR_IntrospectionServer {
  function tutos_services() {
    $this->IXR_IntrospectionServer();
    // Define the exported methods in this array

    // System
    $this->addCallback('tutos.login', 'this:login',
		       array('string', 'string', 'string'),
		       'session_id = login(username, passwd)');

    $this->addCallback('tutos.session', 'this:get_session',
		       array('struct', 'string'), 'Get Session');

    // Products
    $this->addCallback('product.list', 'this:product_list',
		       array('array', 'string'),
		       'Get the products list');

    // Tasks
    $this->addCallback('task.list', 'this:task_list',
		       array('array', 'string'), 'Get the tasks list');

    $this->addCallback('task.row', 'this:task_printRow',
		       array('array', 'string', 'integer'),
		       'Display some tasks');

    // User
    $this->addCallback('user.askPeople', 'this:askPeople',
		       array('array', 'string'), 'Get the people list');

    // Now we can start
    $this->serve();
  }

  /**
   * Login into TUTOS. Currently not usable (see permission.p3)
   */
  function login($args) {
    global $tutos;
    list($login, $passwd) = $args;

    $r = login($login, $passwd);
    if( is_array($r) ) {
      // We have an error code
      return new IXR_Error(-1, $r[1].": ".$r[0]);
    }
    else {
      // We return a session key
      return $tutos['SESSID'];
    }
  }

  /**
   * Get the product list of given user.
   */
  function product_list($user) {
    global $current_user, $lang;

    $r = login($user, "");

    if( is_array($r) ) {
      // We have an error code
      return new IXR_Error(-1, $r[1].": ".$r[0]);
    }
    else {
      include_once 'user.pinc';
      include_once 'product.pinc';

      $r = product::mytutos(&$current_user);
      return $r;
    }
  }

  /**
   * Get the task list of given user
   */
  function task_list($user) {
    global $current_user, $lang;

    $r = login($user, "");

    if( is_array($r) ) {
      // We have an error code
      return new IXR_Error(-1, $r[1].": ".$r[0]);
    }
    else {
      include_once 'task.pinc';
      task::obj_read($current_user);

      $r = array();
      $i = 0;
      foreach($current_user->tasklist as $t) {
	$r[$i]['id']   = $t->id;
	$r[$i]['p_id'] = $t->p_id;
	$r[$i]['name'] = $t->name;
	$r[$i]['volume'] = $t->volume;
	$r[$i]['volume_done'] = $t->volume_done;
	$r[$i]['volume_todo'] = $t->volume_todo;
	$i++;
      }
      return $r;
      
      if( isset($current_user->tasklist) )
	return $current_user->tasklist;
      else
	return new IXR_Error(-1, "Problem");
    }
  }

  /**
   * Returns a list of rows containing each a task to display
   */
  function task_printRow($args) {
    global $current_user, $lang, $dbconn;
    list($user, $id) = $args;

    $r = login($user, "");

    if( is_array($r) ) {
      // We have an error code
      return new IXR_Error(-1, $r[1].": ".$r[0]);
    }
    else {
      include_once 'task.pinc';
      if( $id != -1 ) {
	$parent = getObject($dbconn, $id);
	if( $parent == -1 )
	  return new IXR_Error(-1, "Id Error: ".$id." could not be found");
      }
      else {
	$parent = &$current_user;
      }
      task_calc($parent);

      if ( $parent->getType() == "task" ) {
	$row = $parent->printRow($parent);
      }
      else {
	$row = array();
	foreach( $parent->tasklist as $i => $f ) {
	  $row[] = $parent->tasklist[$i]->printRow($parent);
	}
      }
      return $row;
    }
  }

  /**
   * Get the timetrack list of given user
   */
  function timetrack_list($user) {
    global $current_user, $lang;

    $r = login($user, "");

    if( is_array($r) ) {
      // We have an error code
      return new IXR_Error(-1, $r[1].": ".$r[0]);
    }
    else {
      include_once 'timetrack.pinc';
      timetrack::obj_read($current_user);

      $r = array();
      $i = 0;
      foreach($current_user->ttlist as $t) {
	$r[$i]['id']       = $t->id;
	$r[$i]['link_id']  = $t->link_id;
	$r[$i]['desc']     = $t->desc;
	$r[$i]['volume']   = $t->volume;
	$r[$i]['creation'] = $t->creation;
	$i++;
      }
      return $r;
    }
  }

  /**
   * Get the people connected to given login
   */
  function askPeople($user) {
    global $current_user;
    $r = login($user, "");

    if( is_array($r) ) {
      // We have an error code
      return new IXR_Error(-1, $r[1].": ".$r[0]);
    }
    else {
      $people = $current_user->askPeople($current_user);
      return $people;
    }
  }
}

$xmlrpc_server = new tutos_services();

?>