<?php
/*
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("user","ins");

 $msg = "";
 $u = new tutos_user($dbconn);
 $gotourl = "user_new.php";

 if ( ! isset($_POST['uid']) || empty($_POST['uid']) ) {
   $msg .= "Please enter a id<br>";
 } else if ( $_POST['uid'] != -1 ) {
   # existing entry
   $u->read($_POST['uid'],1);
   $gotourl= addUrlParameter($gotourl,"uid=". $_POST['uid']);
 } else if ( isset($_POST['id']) )  {
   # new entry
   $u->read($_POST['id'],0);
   $gotourl= addUrlParameter($gotourl,"id=". $_POST['id']);
 }

 if ( !isset($_POST['login']) || empty($_POST['login']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['Username']) ."<br>";
 } else {
   $u->setLogin($_POST['login']);
   $gotourl= addUrlParameter($gotourl,"login=". UrlEncode($u->login));
 }

 # This does not work for mysql !!!
 if ( $dbconn->gettype() != "MySQL" ) {
   # Check old password
   if ( (!empty($_POST['p1']) || !empty($_POST['p2'])) && ($current_user->admin == 0) ) {
     if ( "'". $u->pw ."'" != $dbconn->Password($_POST['p0']) ) {
       $msg .= $lang['Err0042'] ."<br>";
     }
   }
 }
 if ( !empty($_POST['p1']) || !empty($_POST['p2']) ) {
   if ( $_POST['p1'] != $_POST['p2'] ) {
     $msg .= $lang['Err0041'] ."<br>";
   }
 }
 
 # Holidays
 $u->holiday = array();
 if (isset($_POST['h']) ) {
   foreach (array_unique($_POST['h']) as $i => $f) {
     $gotourl= addUrlParameter($gotourl,"h[]=". UrlEncode($f));
     $u->holiday[$f] = 1;
   }
 }
 # Namedays
 $u->nameday = array();
 if (isset($_POST['nd']) ) {
   foreach (array_unique($_POST['nd']) as $i => $f) {
     $gotourl= addUrlParameter($gotourl,"nd[]=". UrlEncode($f));
     $u->nameday[$f] = 1;
   }
 }
 # workdays
 if (isset($_POST['wd']) ) {
   $u->workday = array();
   foreach (array_unique($_POST['wd']) as $i => $f) {
     $gotourl= addUrlParameter($gotourl,"wd[]=". UrlEncode($f));
     $u->workday[] = $f;
   }
 }
 # Weekstart
 if (isset($_POST['ws']) ) {
   $u->weekstart = $_POST['ws'];
   $gotourl= addUrlParameter($gotourl,"ws=". UrlEncode($u->weekstart));
 }
 if ( ! $u->mod_ok() ) {
   $msg .= sprintf($lang['Err0024'],$lang[$u->getType()]) ."<br>";
 }

 # Check that there is one admin left
 if ( $u->admin == 1 && ($_POST['admin'] == 0) ) {
   $q = "SELECT * FROM ". $dbconn->prefix ."people WHERE ". $dbconn->colname("admin") ." = 1";
   $r = $dbconn->Exec($q);
   $n = $r->numrows();
   if ( $n == 1 ) {
     $msg .= $lang['Err0047'] ."<br>";
   }
   $r->free();
 }
 # Disabled
 if ( isset($_POST['disabled']) ) {
   $u->setDisabled($_POST['disabled']);
 } else {
   $u->setDisabled(0);
 }

 # will set user-default-acl from input
 unset($u->acldefault);
 if ( isset($_POST['r']) ) {
   @reset($_POST['r']) ;
   while ( list ($i,$f) = @each ($_POST['r']) ) {
     $u->acldefault[$f]=$tutos[seeok];  
   }
 }  
 if ( isset($_POST['m']) ) {
   @reset($_POST['m']) ;
   while ( list ($i,$f) = @each ($_POST['m']) ) {
     $u->acldefault[$f]=$tutos[modok];  
   }
 }  
 if ( isset($_POST['d']) ) {
   @reset($_POST['d']) ;
   while ( list ($i,$f) = @each ($_POST['d']) ) {
     $u->acldefault[$f]=$tutos[delok];  
   }
 }  

 if ( !empty($_POST['p1']) && !empty($_POST['p2']) ) {
   $u->setPassword($_POST['p1']);
   $u->updatepw = 1;
 } else {
   $u->updatepw = 0;
 }

 if ( $u->uid == -1 ) {
   $u->updatepw = 1;
 }

 # Permissions
 $msg .= parse_permission_form($u);

 # other modules
 $msg .= module_parseforms($current_user,$u,$gotourl);

 if ( $msg == "" ) {
   $u->setAdmin($_POST['admin']);
   $u->setLanguage($_POST['lng']);
   $u->setTimezone($_POST['tz']);
   $u->setTheme($_POST['theme']);
   $u->setLayout($_POST['layout']);

   $dbconn->Begin("WORK");
   $msg .= $u->save_permissions();
   $msg .= $u->save();
   $dbconn->Commit("WORK");

   $gotourl = "address_show.php";
   if ( $tutos[demo] == 1 ) {
     $gotourl= addUrlParameter($gotourl,"lg=". $u->lang);
     $gotourl= addUrlParameter($gotourl,"th=". $u->theme);
     $gotourl= addUrlParameter($gotourl,"ly=". $u->ly);
   }
   $gotourl= addUrlParameter($gotourl,"id=". $u->id);
 }
 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));
 $gotourl = addSessionKey($gotourl);

 /* Go back to user mask */
 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: user_ins.php,v 1.38.2.5 2003/07/03 14:35:23 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
