<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup timetrack
 * @module timetrack_del
 * @package timetrack
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'timetrack.pinc';
 include_once 'bug.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("timetrack","del");

 /* Check Input */
 $msg = "";
 $obj = new timetrack($dbconn);

 if ( !isset($_GET['id']) ) {
   $msg .= sprintf($lang['Err0040'],$lang[$obj->getType()]) ."<br>";
 } else {
   $obj->read($_GET['id']);
 }
 if ( $obj->id < 1 ) {
   $msg .= sprintf($lang['Err0040'],$lang[$obj->getType()]) ."<br>";
 }
 if ( ! $obj->del_ok() ) {
   $msg .= sprintf($lang['Err0023'],$lang[$obj->getType()]) ."<br>";
 }

 if ( $msg != "" ) {
   if ( $obj->id > 0 ) {
     $gotourl = $obj->getUrl();
   }
 } else {
   $gotourl = $obj->ref->getUrl();

   $dbconn->Begin("WORK");
   $msg .= $obj->delete();
   $dbconn->Commit("WORK");
 }

 $_SESSION['MSGID'.$obj->id] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". $obj->id);
 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location:". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: timetrack_del.php,v 1.17.2.1 2003/07/24 09:05:08 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
