<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup team
 * @module team_show
 * @package team
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';
 include_once 'address_tools.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("team","show");
 loadlayout();

 function member_sort(&$a,&$b) {
   if ( ($a->gettype() == 'team') && ($b->gettype() != 'team') ) {
     return 1;
   }
   if ( ($b->gettype() == 'team') && ($a->gettype() != 'team') ) {
     return -1;
   }
   # both are the same type, so we can compare
   return ($a->getFullName() < $b->getFullName()) ? -1 : 1;
 }
 /**
  * display an overview of installations
  */
 class team_show extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $lang;


     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"2\">". $lang['Team'] ." ".  $this->obj->name ."</th>\n";
     echo "</tr>\n";
     echo "<tr>\n";
     echo " <td>". $lang['TeamCreation'] ."</td>\n";
     echo " <td>". $this->obj->creation->getLinkDate() ."</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['TeamManager']);
     echo $this->showdata($this->obj->owner->getMailLink(),1);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['AdrEmail']);
     echo $this->showdata(AsEmail($this->obj->email,$this->obj->email,$this->obj->getFullName()),1);
     echo "</tr>\n";

     team::infolist($this->user,$this->obj,2,$this->format);

     echo "<tr>\n";
     echo " <th colspan=\"2\">". $lang['TeamMember'] ."(". count($this->obj->member) .")</th>\n";
     echo "</tr>\n";

     $line = 0;

     usort($this->obj->member,"member_sort");

     foreach ($this->obj->member as  $obj) {
       echo $this->OverviewRowStart($line);
       if ($obj->getType() == "team") {
         echo "<td colspan=\"2\">". $lang[$obj->getType()]." ".$obj->getLink() ."</td>\n";
       } else {
         echo "<td>". $obj->getLink() ."</td>\n";
         echo "<td>". AsEmail($obj->default_email(),$obj->default_email(),$obj->getFullName()) ."</td>\n";
       }
       echo $this->OverviewRowStart($line++);
     }


     product::infolist($this->user,$this->obj,2,$this->format);
     show_module_infolists($this->user,$this->obj,2,$this->format);

     echo $this->obj->getHistoryLink(2);
     echo $this->DataTableEnd();
   }
   /**
    *
    */
   Function navigate() {
   }
   /**
    *
    */
   Function prepare() {
     global $lang,$msg;

     $this->name = $lang['TeamDetail'];

     $this->obj = new team($this->dbconn);
     if ( isset ($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     } else {
       $msg .= $lang['Err0048'] ."<br>";
       $this->stop = true;
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->name .= ": ".$this->obj->getFullName();
       $this->obj->read_member();
     }
     # menu

     if ( $this->user->isAdmin() ) {
       $x = array( url => "team_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['TeamCreateI'],
                   category => array("team","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( url => "team_new.php?id=".$this->obj->id,
                   text => $lang['Modify'],
                   info => sprintf($lang['TeamModifyI'],$this->obj->name),
                   category => array("team","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->user->feature_ok(usetimetrack,PERM_SEE) ) {
       $x = array( url => "timetrack_overview.php?worker=".$this->obj->id,
                   text => $lang['TimetrackBooked'],
                   info => sprintf($lang['TimetrackBookedI'],$this->obj->getFullName()),
                   category => array("timetrack","module")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->user->feature_ok(usetaskmanagement,PERM_SEE) ) {
       $x = array( url => "task_overview.php?id=".$this->obj->id,
                   text => $lang['TaskOverview'],
                   info => sprintf($lang['TaskOverviewInfo'],$this->obj->getFullName()),
                   category => array("task","module")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) 
          && $this->user->feature_ok(usetaskmanagement,PERM_SEE) 
          && $this->user->feature_ok(usetimetrack,PERM_SEE) 
          ) {
       $x = array( url => "res_cal.php?id=".$this->obj->id,
                   text => $lang['ResCal'],
                   info => $lang['ResCal'],
                   category => array("timetrack","task","module")
                 );
       $this->addMenu($x);
     }
     if ( $this->obj->id > 0) {
       $x = $this->obj->getMailLink($this->user);
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->user->feature_ok(usecalendar,PERM_SEE) ) {
       $x = $this->obj->getCalLink($this->user);
       $this->addMenu($x);
     }

     add_module_addlinks($this,$this->obj);

     # add this page to the browsehistory of the users session
     $this->addtohistory();
   }
 }

 $l = new team_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: team_show.php,v 1.43 2003/03/25 19:18:27 gokohnert Exp $
    $Author: gokohnert $
-->