<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * Editing of teams and their permissions
 *
 * @modulegroup team
 * @module team_new
 * @package team
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("team","new");
 loadlayout();

 /**
  * change/modify a team
  */
 class team_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang,$tutos;


     echo "<form name=\"teamadd\" method=\"post\" action=\"team_ins.php\">\n";
     $this->addHidden("id", $this->obj->id);
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"8\">".  sprintf($lang['Showing'],$lang[$this->obj->getType()])."</th>\n";
     echo "</tr>\n";

     if ( $this->obj->id > 0 ) {
       echo "<tr>\n";
       echo " <td>". $lang['TeamCreation'] ."</td>\n";
       echo " <td colspan=\"3\">". $this->obj->creation->getLinkDateTime() ."</td>\n";
       echo " <td colspan=\"4\" align=\"right\">". acl_link($this->obj) ."</th>\n";
       echo "</tr>\n";
     }
     echo "<tr>\n";
     echo $this->showfieldc($lang['TeamName'],1,"name");
     echo " <td colspan=\"7\"><input id=\"name\" size=\"30\" maxlength=\"30\" name=\"name\" value=\"". myentities($this->obj->name) ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['AdrEmail'],0,"email");
     echo " <td colspan=\"7\"><input id=\"rmail\" size=\"60\" maxlength=\"60\" name=\"email\" value=\"". myentities($this->obj->email) ."\"></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['TeamManager'],0,"owner");
     echo " <td colspan=\"7\">\n";
     echo "  <select id=\"owner\" name=\"owner\">\n";
     @reset($this->obj->member);
     $selected = 0;
     while( list ($i,$f) = @each ($this->obj->member)) {
       echo "  <option value=\"".$i ."\" ";
       if ( $i == $this->obj->owner->id ) {
         echo " selected ";
         $selected = 1;
       }
       echo ">". $f->getFullname() ."</option>";
     }
     if ( $selected == 0 ) {
       echo "  <option value=". $this->obj->owner->id ." selected>". $this->obj->owner->getFullname() ."</option>";
     }
     echo "  </select></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <td>&nbsp;</td>\n";
     echo " <th colspan=\"3\"><label for=\"del[]\">". $lang['TeamMember'] ."</label></th>\n";
     echo " <td>&nbsp;</td>\n";
     echo " <th colspan=\"3\"><label for=\"add[]\">". $lang['TeamPosMember'] ."</label></th>\n";
     echo "</tr>\n";


     echo "<tr>\n";
     echo " <td>&nbsp;</td>\n";

     $line = 0;
     echo " <td colspan=\"3\" valign=\"top\">\n<table cellpadding=\"3\" cellspacing=\"0\" class=\"single\" width=\"100%\" border=\"0\">\n";
     foreach($this->obj->member as $i => $f) {
       echo $this->OverviewRowStart($line);
       echo "<td>".  $f->getLink($f->getFullName()) ."</td>";
       if ( $this->obj->owner->id == $i ) {
         echo "<td valign=\"top\"><i>". $lang['TeamManager'] ."</i></td>\n";
       } else {
         echo "<td valign=\"top\">". $lang['Delete'] ."<input type=\"checkbox\" name=\"del[]\" value=\"". $i ."\"></td>\n";
       }
       echo $this->OverviewRowStart($line++);
     }
     echo "</table></td>\n";
     echo " <td>&nbsp;</td>\n";

     if ( $this->user->isadmin() ) {
       # Members of the virtual 0 team
       $x = new team($this->dbconn);
       $x->read(0);
       $x->read_member();
       foreach($x->member as $aid => $o) {
         $uids[$aid] = $o->getFullName();
         $cchecked[$aid] = "";
       }
       $q = "SELECT id,name FROM ". $x->tablename ;
       $r = $this->dbconn->Exec($q);
       $n = $r->numrows();
       $a = 0;
       while ( $a < $n ) {
         $aid = $r->get($a,"id");
         if ($aid == $this->obj->id) {
           $a++;
           continue;
         }

         $uids[$aid] = $lang['Team']." ".$r->get($a,"name");
         $cchecked[$aid] = "";
         $a++;
       }
       $r->free();
       unset($x);
     } else {
       $this->user->readKnownParties();
       foreach($this->user->a_parties as $aid => $f) {
         $uids[$aid] = $f;
         $cchecked[$aid] = "";
       }
       foreach($this->user->t_parties as $aid => $f) {
         if ($aid == $this->obj->id) continue;
         $uids[$aid] = $f;
         $cchecked[$aid] = "";
       }
     }
     # Remove team where we are member
     foreach ($this->obj->teamlist as $aid => $f) {
       unset($uids[$aid]);
       unset($cchecked[$aid]);
     }
     # Remove Current Members
     foreach($this->obj->member as $aid => $adr) {
       unset($uids[$aid]);
     }
     echo "<td colspan=\"3\" valign=\"top\">";
     echo "<select multiple size=\"". min(count($uids),10) ."\" name=\"add[]\">\n";
     foreach($uids as $i => $f) {
       $cchecked[$i] = "";
     }
     foreach($uids as $i => $f) {
       echo " <option value=\"". $i ."\" ". $cchecked[$i] .">". myentities($f) ."</option>\n";
     }
     echo "</select></td>";
     echo "</tr>\n";

     module_addforms($this->user,$this->obj,8);

     # Feature Permisssions
     permission_form($this,$this->user,$this->obj);

     echo "<tr>\n";
     if ( $this->obj->id == 0 ) {
       echo "<td colspan=\"8\"><span class=\"warn\">". $lang['Err0021'] ."</span><td>";
     } elseif ( $this->obj->id == -1 ) {
       submit_reset(0,-1,3,1,3,0);
     } else {
       submit_reset(0,1,3,1,3,0);
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("teamadd.name");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$tutos,$lang;

     $this->obj = new team($this->dbconn);
     if ( isset($_GET['id'])  ) {
       $this->obj->read($_GET['id']);
       $this->obj->read_member();
       $this->obj->read_permissions();
       $this->name = $lang['TeamModify'] .": ". $this->obj->getFullName();
       team::obj_read($this->obj);
     } else {
       $this->obj->name = $lang['PlsChangeName'];
       $this->name = $lang['TeamCreate'];
       $this->member[$this->user->id] = $this->user;
     }
     if ( isset($_GET['name']) ) {
       $this->obj->name = trim(Stripslashes($_GET['name']));
     }
     if ( isset($_GET['email']) ) {
       $this->obj->email = trim(Stripslashes($_GET['email']));
     }
     if ( ($this->obj->id < 0) && !$this->user->feature_ok(useteams,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if (! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     # menu
     if ( $this->user->feature_ok(useteams,PERM_NEW) ) {
       $x = array( url => "team_new.php",
                   text => $lang['NewEntry'],
                   info => $lang['TeamCreateI'],
                   category => array("team","new","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "team_del.php?id=".$this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['TeamDeleteI'],$this->obj->getFullName()),
                   category => array("team","del","obj")
                 );
       $this->addMenu($x);
     }
     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new team_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: team_new.php,v 1.40.2.1 2003/07/31 17:56:14 gokohnert Exp $
    $Author: gokohnert $
-->