<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup product
 * @module product_ins
 * @package product
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'bug.pinc';
 include_once 'product.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('product','ins');

 $gotourl = "product_new.php";
 $msg = "";
 $mods = 0;

 $p = new product($dbconn);
 if ( isset($_POST['id']) ) {
   $p->read($_POST['id']);
   $p->readroles();
   $gotourl= addUrlParameter($gotourl,"id=". $_POST['id']);
 } else {
   $p->id = -1;
   $p->creator = $current_user;
 }


 # Delete given Roles
 if ( isset($_POST['del']) ) {
   @reset ($_POST['del']);
   while( list ($i,$f) = @each ($_POST['del'])) {
     ereg ("([0-9]*),([0-9]*)",$f,$regs);
     $m = getObject($dbconn,$regs[1]);
     $p->delRole($m,$regs[2]);
     $gotourl= addUrlParameter($gotourl,"del[]=". $f);
   }
 }

 # Add given People Role
 if ( isset($_POST['r1fn']) ) {
   $m = check_field(StripSlashes($_POST['r1fn']),"r1fn","r1l",$tutos[rolecheck][$_POST['role1']]);
   if ( $m->id > 0 ) {
     $p->setRole($m,$_POST['role1'],StripSlashes($_POST['r1desc']));
   }
 }
 if ( isset($_POST['r1id']) ) {
   $m = getObject($dbconn,$_POST['r1id']);
   $p->setRole($m,$_POST['role1'],StripSlashes($_POST['r1desc']));
 }
 $gotourl= addUrlParameter($gotourl,"role1=". $_POST['role1']);
 $gotourl= addUrlParameter($gotourl,"r1desc=". UrlEncode($_POST['r1desc']));
 # Add given Product Role
 if ( isset($_POST['r2fn']) ) {
   $m = check_field(StripSlashes($_POST['r2fn']),"r2fn","r2l",$tutos[rolecheck][$_POST['role2']]);
   if ( $m->id > 0 ) {
     $p->setRole($m,$_POST['role2'],StripSlashes($_POST['r2desc']));
   }
 }
 if ( isset($_POST['r2id']) ) {
   $m = getObject($dbconn,$_POST['r2id']);
   $p->setRole($m,$_POST['role2'],StripSlashes($_POST['r2desc']));
 }
 $gotourl= addUrlParameter($gotourl,"role2=". $_POST['role2']);
 $gotourl= addUrlParameter($gotourl,"r2desc=". UrlEncode($_POST['r2desc']));


 # Check if at least one manager exists
 if ( count($p->role[1]) < 1 ) {
   $msg .= sprintf($lang['Err0009'],$lang['ProdRole'][1]) ."<br>";
 }

 if ( !isset($_POST['name']) || (trim($_POST['name']) == "") ) {
   $msg .= sprintf($lang['Err0009'],$lang['ProdName']) ."<br>";
 } else {
   $mods += $p->setName(StripSlashes(trim($_POST['name'])));
   $gotourl= addUrlParameter($gotourl,"name=". UrlEncode($p->name));
 }

 if ( isset($_POST['version']) ) {
   $mods += $p->setVersion(StripSlashes(trim($_POST['version'])));
   $gotourl= addUrlParameter($gotourl,"version=". UrlEncode($p->version));
 }

 if ( !isset($_POST['state']) ) {
   $msg .= sprintf($lang['Err0014'],$lang['ProdState']) ."<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"state=". $_POST['state']);
 }

 $price = 0.0;
 list($price) = sscanf($_POST['price'],"%f");
 if ( !empty($price) && !is_double($price) ) {
   $msg .= sprintf($lang['Err0017'],$lang['ProdPrice']) ."<br>";
 }

 $cost = 0.0;
 list($cost) = sscanf($_POST['cost'],"%f");
 if ( !empty($cost) && !is_double($cost) ) {
   $msg .= sprintf($lang['Err0017'],$lang['ProdCost']) ."<br>";
 }

 $prob = 0.0;
 list($prob) = sscanf($_POST['prob'],"%f");
 if ( !empty($prob) && !is_double($prob) ) {
   $msg .= sprintf($lang['Err0017'],$lang['ProdProb']) ."<br>";
 }

 $gotourl= addUrlParameter($gotourl,"price=". $price);
 $gotourl= addUrlParameter($gotourl,"cost=". $cost);
 $gotourl= addUrlParameter($gotourl,"prob=". $prob);
 $gotourl= addUrlParameter($gotourl,"desc1=". UrlEncode(StripSlashes($_POST['desc1'])));
 $gotourl= addUrlParameter($gotourl,"desc2=". UrlEncode(StripSlashes($_POST['desc2'])));
 $gotourl= addUrlParameter($gotourl,"description=". UrlEncode(StripSlashes($_POST['description'])));
 $gotourl= addUrlParameter($gotourl,"path=". UrlEncode(StripSlashes($_POST['path'])));
 $gotourl= addUrlParameter($gotourl,"currency=". UrlEncode(StripSlashes($_POST['currency'])));


 $pstart = new DateTime(0);
 $pstart->setDateTimeF("p_start");
 $gotourl= addUrlParameter($gotourl,"p_start=". $pstart->getYYYYMMDD() );
 if ( 1 != $pstart->checkDMY() ) {
   $msg .= sprintf($lang['Err0038'],$lang['ProdStart']) ."<br>";
 }

 $pend = new DateTime(0);
 $pend->setDateTimeF("p_end");
 $gotourl= addUrlParameter($gotourl,"p_end=". $pend->getYYYYMMDD() );
 if ( 1 != $pend->checkDMY() ) {
   $msg .= sprintf($lang['Err0038'],$lang['ProdEnd']) ."<br>";
 }
 if ( $pend->ts > -1 && ($pstart->ts > $pend->ts) ) {
   # Start after End
   $msg .= $lang['Err0002'] ."<br>";
 }


 # Classification
 for ( $cl = 1;$cl <= $p->classes; $cl++) {
   $p->cl[$cl] = array();
   $x = sprintf("cl%d",$cl);
   if ( isset($_POST[$x]) ) {
     @reset($_POST[$x]);
     while ( list ($i,$f) = @each ($_POST[$x]) ) {
       $gotourl= addUrlParameter($gotourl,"cl".$cl."[]=".$f );
       $p->cl[$cl][] = $f;
     }
   }
   else {
     if( $tutos[classify_products] ) {
       $msg .= $lang['Err0052']."<br>";
       # just output this message once
       break;
     }
   }
 }

 # If no other problems than check if name is already used
 if ( $msg == "" ) {
   if ( ($p->id == -1) || ($mods > 0) ) {
     $q = "SELECT * FROM ". $p->tablename ." WHERE ". $dbconn->Like2("name",$p->name) ." AND ". $dbconn->Like2("version",$p->version);
#	 echo $q;
     $r = $dbconn->Exec($q);
     $n = $r->numrows();
     if ( 0 != $n) {
       $x = new product($dbconn);
       $x->read_result($r,0);
       $msg .= sprintf($lang['Err0036'],$x->getLink()) ."<br>";
     }
     $r->free();
   }
 }

 # other modules
 $msg .= module_parseforms($current_user,$p,$gotourl);

 if ( $msg == "" ) {
   $p->setDescription(trim(StripSlashes($_POST['description'])));
   $p->setDesc1(trim(StripSlashes($_POST['desc1'])));
   $p->setDesc2(trim(StripSlashes($_POST['desc2'])));
   $p->setPrice($price);
   $p->setCost($cost);
   $p->setProbability($prob);
   $p->setCurrency($_POST['currency']);
   $p->setState($_POST['state']);
   $p->setPath(StripSlashes($_POST['path']));

   $p->setPStart($pstart);
   $p->setPEnd($pend);

   $dbconn->Begin("WORK");
   $msg .= $p->save();
   $dbconn->Commit("WORK");

   $gotourl = $p->getURL();
 }

 $gotourl = addSessionKey($gotourl);
 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: product_ins.php,v 1.42.2.3 2003/07/24 19:17:41 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
